
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow() :
  toolbar_("Click confirm or the back arrow", "Confirm")
{
  set_title("Hildon::EditToolbar Example");

  set_edit_toolbar(toolbar_);
  toolbar_.show();

  toolbar_.signal_button_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  toolbar_.signal_arrow_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_arrow_clicked));

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_clicked()
{
  unset_edit_toolbar();
  std::cout << "Button clicked." << std::endl;
}

void ExampleWindow::on_arrow_clicked()
{
  unset_edit_toolbar();
  std::cout << "Arrow clicked." << std::endl;
}
