
/* Copyright: (c) 2005-2009 Nokia Corporation
 *
 * The code examples copyrighted by Nokia Corporation that are included to
 * this material are licensed to you under following MIT-style License:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow() :
  hbox_(false, 6),  //TODO: See https://bugs.maemo.org/show_bug.cgi?id=4464 for correct spacing
  vbox_(false, 6), //TODO: See https://bugs.maemo.org/show_bug.cgi?id=4464 for correct spacing.
  button_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click Me",
    "to print text in entry"),
  label_("Hildon::Entry example"),
  entry_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT)
{
  set_title("Hildon::Entry Example");

  entry_.set_placeholder("This is placeholder text");

  buttonbox_.pack_start(button_);

  hbox_.pack_start(label_, Gtk::PACK_SHRINK);
  hbox_.pack_start(entry_);

  vbox_.pack_start(buttonbox_, Gtk::PACK_SHRINK);
  vbox_.pack_start(hbox_, Gtk::PACK_SHRINK);

  add(vbox_);

  button_.signal_clicked().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_button_clicked));
  entry_.signal_activate().connect(
    sigc::mem_fun(*this, &ExampleWindow::on_entry_activated));

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_clicked()
{
  std::cout << "Button clicked. Current entry text=\"" << entry_.get_text() <<
    "\"." << std::endl;
}

void ExampleWindow::on_entry_activated()
{
  std::cout << "Entry activated. Current text=\"" << entry_.get_text() << "\"."
    << std::endl;
}

