/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <hildonmm/note.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  button_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click me! (three times)",
    "to show notes"),
  type_(1)
{    
  set_title("Hildon::Note example");
  
  // Attach the callback functions to the clicked signal.
  button_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_button));
  
  box_.pack_start(button_);
  add(box_);
  
  // Make all widgets visible.
  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button()
{
  switch (type_)
  {
    case 1:
    {
      Hildon::Note note(Hildon::NOTE_TYPE_INFORMATION, "Very important information. (click to dismiss)");
      note.run();
      break;
    }
    case 2:
    {
      Hildon::Note note(Hildon::NOTE_TYPE_CONFIRMATION_BUTTON, *this, "Do you agree?");
      note.add_button(Gtk::Stock::YES, Gtk::RESPONSE_YES);
      note.add_button(Gtk::Stock::NO, Gtk::RESPONSE_NO);
      
      note.run();
      break;
    }
    case 3:
    {
      Hildon::Note* note = new Hildon::Note(bar_, *this, "Note with ProgressBar");
      bar_.set_fraction(0.5);
      note->run();
      delete note;
    }
  }
  
  type_++;
  if(type_ > 3)
     type_ = 1;
}
