/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#ifndef _MAEMOMM_EXAMPLEWINDOW_H
#define _MAEMOMM_EXAMPLEWINDOW_H

#include <hildonmm/window.h>
#include <hildonmm/find-toolbar.h>
#include <gtkmm.h>

class ExampleWindow : public Hildon::Window
{
public:
  ExampleWindow();
  virtual ~ExampleWindow();

protected:
  // Signal handlers:
  void on_item_close();
  void on_find_toolbar_close();
  void on_find_toolbar_search();

  // Child widgets:
  Gtk::Toolbar main_toolbar_;
  Hildon::FindToolbar find_toolbar_;
  
  Gtk::ToolButton tool_new_;
  Gtk::ToolButton tool_open_;
  Gtk::ToolButton tool_save_;
  Gtk::ToolButton tool_close_;
  Gtk::ToolButton tool_find_;
  Gtk::SeparatorToolItem tool_separator_;
  Gtk::ToolItem tool_combo_;
  
  Gtk::Menu main_;
  Gtk::Menu sub_others_;
  
  Gtk::MenuItem item_others_;
  Gtk::RadioMenuItem::Group group_;
  Gtk::RadioMenuItem item_radio1_;
  Gtk::RadioMenuItem item_radio2_;
    
  Gtk::CheckMenuItem item_check_;
  Gtk::CheckMenuItem item_close_;
  Gtk::SeparatorMenuItem item_separator_;
  
  // Member variables:
  bool find_visible_;
};

#endif /* _MAEMOMM_EXAMPLEWINDOW_H */
