/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  find_toolbar_("Find string: "),
  tool_new_(Gtk::Stock::NEW),
  tool_open_(Gtk::Stock::OPEN),
  tool_save_(Gtk::Stock::SAVE),
  tool_close_(Gtk::Stock::CLOSE),
  tool_find_(Gtk::Stock::FIND),
  item_others_("Others"),
  item_radio1_(group_, "Radio1"),
  item_radio2_(group_, "Radio2"),  
  item_check_("Check"),
  item_close_("Close")
{
  // Create Combobox on tool item.
  Gtk::ComboBoxText* combo = Gtk::manage(new Gtk::ComboBoxText);
  combo->append_text("Entry 1");
  combo->append_text("Entry 2");
  combo->append_text("Entry 3");	
  combo->set_active(1);
  tool_combo_.set_expand();
  tool_combo_.add(*combo);
  
  // Add toolbar items to toolbar.
  main_toolbar_.append(tool_new_);
  main_toolbar_.append(tool_separator_);
  main_toolbar_.append(tool_open_);
  main_toolbar_.append(tool_save_);
  main_toolbar_.append(tool_combo_);
  main_toolbar_.append(tool_find_);
  main_toolbar_.append(tool_close_);
  main_toolbar_.show_all();
  
  // Attach the callback functions to the activate signal.
  tool_close_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_item_close));
  
  // Attach find toolbar callbacks.
  find_toolbar_.signal_close().connect(sigc::mem_fun(*this, &ExampleWindow::on_find_toolbar_close));
  find_toolbar_.signal_search().connect(sigc::mem_fun(*this, &ExampleWindow::on_find_toolbar_search));	
  tool_find_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_find_toolbar_close));
  
  // Attach find toolbar.
  add_toolbar(main_toolbar_);
  add_toolbar(find_toolbar_);
  
  // Add menu items to right menus.
  main_.append(item_others_);
  sub_others_.append(item_radio1_);
  sub_others_.append(item_radio2_);
  sub_others_.append(item_separator_);
  sub_others_.append(item_check_);
  main_.append(item_close_);
  
  // Add others submenu to the "Others" item.
  item_others_.set_submenu(sub_others_);
  main_.show_all(); // Show the menu and all its child widgets.
  set_main_menu(main_);

  // Attach the callback functions to the activate signal.
  item_close_.signal_activate().connect(sigc::mem_fun(*this, &ExampleWindow::on_item_close));
  
  show_all();
  find_toolbar_.hide();
  
  find_visible_ = false;
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_item_close()
{
  hide();
}

void ExampleWindow::on_find_toolbar_close()
{
  // Show or hide find toolbar.
  if(find_visible_)
  {
    find_toolbar_.hide();
    find_visible_ = false;
  }
  else
  {
    find_toolbar_.show();
    find_visible_ = true;
  }
}

void ExampleWindow::on_find_toolbar_search()
{
  // TODO: This code does not work!
  Glib::ustring prefix;
  find_toolbar_.get_property("prefix", prefix);
  std::cout << "Search for: " << prefix << std::endl;
}
