/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <hildon-fmmm/file-chooser-dialog.h>
#include <hildon-fmmm/file-details-dialog.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  button_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click me!",
    "to select a file")
{
  set_title("Hildon::FileDetailsDialog example");

  add(box_);

  box_.pack_start(button_, Gtk::PACK_SHRINK);
  button_.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_button_clicked) );

  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_clicked()
{
  Hildon::FileChooserDialog dialog(*this, Gtk::FILE_CHOOSER_ACTION_OPEN);

  Gtk::FileFilter filter_any;
  filter_any.set_name("Any files");
  filter_any.add_pattern("*");
  dialog.add_filter(filter_any);

  //Show the dialog and wait for a user response:
  int response = dialog.run();

  //Handle the response:
  switch(response)
  {
    case(Gtk::RESPONSE_OK):
    {
      const std::string filename = dialog.get_filename();
      std::cout << "filename chosen: " << filename << std::endl;

      // Create a Hildon::FileSystemModel
      Glib::RefPtr<Hildon::FileSystemModel> fs_model = Hildon::FileSystemModel::create(*this /* ref-widget */);


      // Create a Hildon::FileDetailsDialog
      Hildon::FileDetailsDialog fd_dialog(fs_model);


      // Tell the FileDetailsDialog to show this file:
      Gtk::TreeModel::iterator iter = fs_model->load_local_path(filename);
      if(iter) //TODO (low priority): load_local_path() always seems to return a null iter.
      {
        
        fd_dialog.set_file_iter(iter);
      }
      else
        std::cerr << "Hildon::FileSystemModel::load_local_path(" << filename << ") failed" << std::endl;


      // Show the dialog
      fd_dialog.set_transient_for(*this);
      fd_dialog.run();

      break;
    }
    case(Gtk::RESPONSE_CANCEL):
    {
      std::cout << "Cancel clicked." << std::endl;
      break;
    }
    default:
    {
      std::cerr << "Unexpected button clicked." << std::endl;
      break;
    }
  }
  
}
