/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <hildon-fmmm/file-chooser-dialog.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  button_file_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click me!",
    "to select a file"),
  button_folder_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT,
    Hildon::BUTTON_ARRANGEMENT_VERTICAL,
    "Click me!",
    "to select a folder")
{
  set_title("Hildon::FileChooserDialog example");

  add(box_);

  box_.pack_start(button_file_);
  button_file_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_button_file_clicked));

  box_.pack_start(button_folder_);
  button_folder_.signal_clicked().connect(sigc::mem_fun(*this, &ExampleWindow::on_button_folder_clicked));

  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_button_folder_clicked()
{
  Hildon::FileChooserDialog dialog(*this, Gtk::FILE_CHOOSER_ACTION_SELECT_FOLDER);

  int response = dialog.run();

  // Handle the response:
  switch(response)
  {
    case(Gtk::RESPONSE_OK):
    {
      std::cout << "Select clicked." << std::endl;
      std::cout << "Folder selected: " << dialog.get_filename() << std::endl;
      break;
    }
    case(Gtk::RESPONSE_CANCEL):
    {
      std::cout << "Cancel clicked." << std::endl;
      break;
    }
    default:
    {
      std::cout << "Unexpected button clicked." << std::endl;
      break;
    }
  }
}

void ExampleWindow::on_button_file_clicked()
{
  Hildon::FileChooserDialog dialog(*this, Gtk::FILE_CHOOSER_ACTION_OPEN);
 
  // Add filters, so that only certain file types can be selected:

  Gtk::FileFilter filter_text;
  filter_text.set_name("Text files");
  filter_text.add_mime_type("text/plain");
  dialog.add_filter(filter_text);

  Gtk::FileFilter filter_cpp;
  filter_cpp.set_name("C/C++ files");
  filter_cpp.add_mime_type("text/x-c");
  filter_cpp.add_mime_type("text/x-c++");
  filter_cpp.add_mime_type("text/x-c-header");
  dialog.add_filter(filter_cpp);
  
  Gtk::FileFilter filter_any;
  filter_any.set_name("Any files");
  filter_any.add_pattern("*");
  dialog.add_filter(filter_any);

  //Show the dialog and wait for a user response:
  int response = dialog.run();

  //Handle the response:
  switch(response)
  {
    case(Gtk::RESPONSE_OK):
    {
      std::cout << "Open clicked." << std::endl;

      std::string filename = dialog.get_filename(); //Notice that it is a std::string, not a Glib::ustring.
      std::cout << "File selected: " <<  filename << std::endl;
      break;
    }
    case(Gtk::RESPONSE_CANCEL):
    {
      std::cout << "Cancel clicked." << std::endl;
      break;
    }
    default:
    {
      std::cout << "Unexpected button clicked." << std::endl;
      break;
    }
  }
  
}
