/* maemomm example Copyright 2009 Openismus GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "examplewindow.h"
#include <gtkmm.h>
#include <iostream>

ExampleWindow::ExampleWindow() :
  entry_name_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT),
  entry_street_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT),
  entry_position_(Gtk::Hildon::SIZE_HALFSCREEN_WIDTH | Gtk::Hildon::SIZE_FINGER_HEIGHT),
  icon1_(Gtk::Stock::NEW, Gtk::ICON_SIZE_BUTTON),
  icon2_(Gtk::Stock::NEW, Gtk::ICON_SIZE_BUTTON),
  icon3_(Gtk::Stock::NEW, Gtk::ICON_SIZE_BUTTON)
{
  set_title("Hildon::Caption example");

  // Set some silly test
  entry_name_.set_placeholder("Mr. Example");
  group_ = Gtk::SizeGroup::create(Gtk::SIZE_GROUP_VERTICAL);
  
  // Create the captions
  Hildon::Caption* caption_name = Gtk::manage(new Hildon::Caption(
    group_,
    "Name",
    entry_name_,
    icon1_));
  caption_name->signal_activate().connect( sigc::mem_fun(*this, &ExampleWindow::on_activate));

  Hildon::Caption* caption_street = Gtk::manage(new Hildon::Caption(
    group_,
    "Street",
    entry_street_,
    icon2_));
  caption_street->signal_activate().connect( sigc::mem_fun(*this, &ExampleWindow::on_activate));
  
  Hildon::Caption* caption_position = Gtk::manage(new Hildon::Caption(
    group_,
    "Position",
    entry_position_,
    icon3_));
  caption_position->signal_activate().connect( sigc::mem_fun(*this, &ExampleWindow::on_activate));

  box_.pack_start(*caption_name);
  box_.pack_start(*caption_street);
  box_.pack_start(*caption_position);
  add(box_);  
  
  // Make all child widgets visible,
  // so they will be visible when this window is shown:
  show_all();
}

ExampleWindow::~ExampleWindow()
{
}

void ExampleWindow::on_activate()
{
  std::cout << "Caption activated." << std::endl;
}
