/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    main.qml
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

//import QtQuick 1.0
//import Qt.labs.components.native 1.0
//import com.nokia.extras 1.0
import QtQuick 1.0
import org.maemo.fremantle 1.0
import org.maemo.extras 1.0

Rectangle {
    id: rectangle1
    width: 800
    height: 480
    color: "#000000"
    //    Connections {
    //        target: BetweenTime
    //        onNotifyBoolValueChange: textt.text = Instance.isTrue
    //    }
    //==============================================================
    Column {
        id: columnbuttons
        x: 0
        y: 23
        width: parent.width
        height: 100
        anchors.horizontalCenter: parent.horizontalCenter
        anchors.verticalCenterOffset: -119
        anchors.verticalCenter: parent.verticalCenter
        smooth: false
        spacing: 2
        //================================
        //================================

        Button {
            id: startButton
            width: parent.width
            height: 50
            text: "Start time"

            onClicked: {
                launchDialogToTimeStart(Instance.startTimeHour,Instance.startTimeMinute ); //Qt.quit();
            }
        }
        //==============================================================
        //=============================================================

        Button {
            id: endButton
            width: parent.width
            height: 50
            text: "End time"

            onClicked: {
                launchDialogToTimeStop(Instance.endTimeHour, Instance.endTimeMinute); //Qt.quit();
            }
        }
    }

    TimePickerDialog {
        id: tDialogStop
        titleText: "Stop time"
        onAccepted: callbackFunctionStop()
        acceptButtonText: "ok"
        rejectButtonText: "cancel"
    }


    Grid {
        id: grid1
        x: 0
        y: 174
        width: parent.width
        height: 226
        smooth: false
        spacing: 69
        rows: 2
        columns: 2

        Text {
            id: starttimetext
            x: 27
            y: 125
            width: 100
            height: 100
            color: "#ffffff"
            text: qsTr("Start Time")
            anchors.horizontalCenterOffset: -100
            anchors.horizontalCenter: parent.horizontalCenter
            scale: 1
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignHCenter
            font.pixelSize: 30
        }

        Text {
            id: stoptimetxt
            width: 100
            height: 100
            color: "#ffffff"
            text: qsTr("Stop time")
            anchors.horizontalCenterOffset: 100
            anchors.horizontalCenter: parent.horizontalCenter
            scale: 1
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            font.pixelSize: 30
        }

        Text {
            id: starttext
            x: 27
            y: 70
            width: 100
            height: 100
            color: "#ffffff"
            text: Instance.isSetStart ?  Instance.getStartTostring() : qsTr("Not Set Jet")
            font.pixelSize: 30
            //ono to tak problikne
            Behavior on text   {
                SequentialAnimation {
                    NumberAnimation { target: starttext; property: "opacity"; to: 0 ; duration: 500}
                    PropertyAction {}//tady se zmeni cas
                    NumberAnimation { target: starttext; property: "opacity"; to: 1 ; duration: 500}
                }
            }
            anchors.horizontalCenterOffset: -100
            anchors.horizontalCenter: parent.horizontalCenter
            horizontalAlignment: Text.AlignHCenter
        }

        Text {
            id: stoptext
            width: 100
            height: 100
            color: "#ffffff"
            text: Instance.isSetEnd ? Instance.getEndTostring() : qsTr("Not Set Jet")
            font.pixelSize: 30
            Behavior on text   {
                SequentialAnimation {
                    NumberAnimation { target: stoptext; property: "opacity"; to: 0; duration: 500 }
                    PropertyAction {} //tady se zmeni ten cas az
                    NumberAnimation { target: stoptext; property: "opacity"; to: 1; duration: 500 }
                }
            }
            anchors.horizontalCenterOffset: 100
            anchors.horizontalCenter: parent.horizontalCenter
            horizontalAlignment: Text.AlignHCenter
        }

    }

    TimePickerDialog {
        id: tDialogStart
        x: -18
        y: 217
        titleText: "Start time"
        onAccepted: callbackFunctionStart()
        acceptButtonText: "ok"
        rejectButtonText: "cancel"
    }

    function launchDialogStart() {
        tDialogStart.open();
    }

    function launchDialogToTimeStart(hour, minute) {
        tDialogStart.hour = hour;
        tDialogStart.minute = minute;
        tDialogStart.hourMode = DateTime.TwentyFourHours;
        tDialogStart.fields = DateTime.Hours | DateTime.Minutes;
        tDialogStart.open();
    }

    function callbackFunctionStart() {
        // 21 May 2001 14:13:09
        var dateTime = new Date(0, 0, 0, tDialogStart.hour, tDialogStart.minute, 0)
        console.log(dateTime)
        //textt.text = tDialogStart.hour + ":" + tDialogStart.minute + ":" + tDialogStart.second
        if(Instance.isSetEnd)//pokud je max nastaveno tak kontrola
        {
            var hoursMax = new Date(0, 0, 0, 0,0, 0)
            hoursMax.setMinutes(  Instance.endTimeMinute)
            hoursMax.setHours( Instance.endTimeHour )
            if((dateTime.getHours() > hoursMax.getHours()) )
            {
                showBanner()
                return
            }
            else if((dateTime.getHours() == hoursMax.getHours()) && (dateTime.getMinutes() >= hoursMax.getMinutes()))
            {
                showBanner()
                return
            }
        }
        Instance.setStartTime(tDialogStart.hour,tDialogStart.minute);
        //starttext.text = Qt.formatTime( dateTimee, "hh:mm:ss" )
    }
    //==============================================================

    function launchDialogStop() {
        tDialogStop.open();
    }

    function launchDialogToTimeStop(hour, minute) {
        tDialogStop.hour = hour;
        tDialogStop.minute = minute;
        tDialogStop.hourMode = DateTime.TwentyFourHours;
        tDialogStop.fields = DateTime.Hours | DateTime.Minutes;
        tDialogStop.open();
    }

    function callbackFunctionStop() {
        // 21 May 2001 14:13:09
        var dateTime = new Date(0, 0, 0, tDialogStop.hour, tDialogStop.minute, 0)
        //textt.text = tDialogStart.hour + ":" + tDialogStart.minute + ":" + tDialogStart.second
        if(Instance.isSetStart)//pokud je max nastaveno tak kontrola
        {
            var hoursMin = new Date(0, 0, 0, 0,0, 0)
            hoursMin.setMinutes( Instance.startTimeMinute )
            hoursMin.setHours( Instance.startTimeHour )

            if((dateTime.getHours() < hoursMin.getHours()) )
            {
                showBanner()
                return
            }
            else if(((dateTime.getHours() == hoursMin.getHours())) && dateTime.getMinutes() <= hoursMin.getMinutes())
            {
                showBanner()
                return
            }
        }
        Instance.setEndTime(tDialogStop.hour,tDialogStop.minute);
        //starttext.text = Qt.formatTime( dateTimee, "hh:mm:ss" )
    }

    //================================================================
    //================================
    //pro info o chybe pri zadavani casu
    //    InfoBanner {
    //	id: banner
    //	text: qsTr("Time is overlapping")
    //    }

    function showBanner() {
        // set display time to 5000 ms, default is 3000 ms
        //banner.timeout = 5000;
        // display info banner
        //banner.open();
    }
}
