/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    incomingcall.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include "incomingcall.h"
#include <QtCore/QDebug>
#include <QtDBus/QDBusConnection>
#include <QDBusMessage>
#include <QtCore/QTimer>
#include <QDBusInterface>

static const char* CALL_DBUS_SERVICE =  "com.nokia.csd.Call";
static const char* CALL_DBUS_OBJECT_PATH =  "/com/nokia/csd/call/1";
static const char* CALL_DBUS_INTERFACE = "com.nokia.csd.Call.Instance";
static const char* CALL_DBUS_METHOD = "GetStatus";

IncomingCall::IncomingCall(ConditionInterface *interface) :
	Condition(interface)
{
	timer = new QTimer(this);
	timer->setSingleShot(true);//A single-shot timer fires only once

	connect(timer,SIGNAL(timeout()),this,SLOT(TimerTimeout()));
	bool succ =   QDBusConnection::systemBus().connect( "", "/com/nokia/csd/call", "com.nokia.csd.Call", "Coming", this, SLOT(receiveCall(const  QDBusMessage&)));

	if(succ){
		qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "anooooooooooooooooooooooooooooooooooooooo:";
	} else {
		qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "neeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee:";
	}
}

void IncomingCall::load(const QByteArray &data)
{
}

QByteArray IncomingCall::save() const
{
	return QByteArray();
}

void IncomingCall::receiveCall(const QDBusMessage &)
{
	timer->start(1000);
	setState(true);
}

void IncomingCall::TimerTimeout()
{
	qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "timer  timeout" ;

	QDBusConnection systemDbusConnection = QDBusConnection::systemBus();
	QDBusInterface connectionInterface(CALL_DBUS_SERVICE,
									   CALL_DBUS_OBJECT_PATH,
									   CALL_DBUS_INTERFACE,
									   systemDbusConnection);
	if (!connectionInterface.isValid()) {
		qWarning() << "Cannotct conect to D-BUS";
		setState(false);
		return;
	}
	//poslu zpravu ze chcu info
	QDBusMessage reply = connectionInterface.call(QLatin1String(CALL_DBUS_METHOD));
	if (reply.type() == QDBusMessage::ReplyMessage) {
		QList<QVariant> argList = reply.arguments();
		//   currentCellNetworkStatus = argList.at(INDEX_OF_NEVIM).toInt();
		foreach(QVariant var, argList)
		{
			qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << " hodnota :::" << var.toString();
		}
		if(reply.arguments().at(0).toString() != "0")
		{
			qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "nebyl nula" ;
			timer->start(2000);
			return;
		}
		else{
			qDebug() << "In file:" <<  __FILE__ << ":" << "on line:" << __LINE__ << " in function:" << __FUNCTION__ << "text::" << "ted jo" ;
			setState(false);
		}
	}
	else
	{
		qWarning() << reply.errorMessage();
		setState(false);
	}
}

Q_EXPORT_PLUGIN2(incomingcall, IncomingCallInterface)
