/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    currentprofile.cpp
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

#include "currentprofile.h"
#include <QDebug>
CurrentProfile::CurrentProfile(ConditionInterface *interface) :
    Condition(interface),selectedProfileState(1)
{
    deviceInfo = new QSystemDeviceInfo(this);
    connect(deviceInfo,SIGNAL(currentProfileChanged(QSystemDeviceInfo::Profile)),this,SLOT(profileStateChanged(QSystemDeviceInfo::Profile)));
    connect(deviceInfo,SIGNAL(currentProfileChanged(QSystemDeviceInfo::Profile)),this,SIGNAL(notifyProfileStateChanged()));

}


void CurrentProfile::update()
{
    qDebug() << "je update";
    profileStateChanged(deviceInfo->currentProfile());
}

void CurrentProfile::profileStateChanged(QSystemDeviceInfo::Profile profile)
{
    qDebug() << "profil " << profile << " a mam nastavneno  " << selectedProfileState;
    if(selectedProfileState == -1 || profile == 0)//BatteryUnknown
    {
	setState(false);
	return;
    }

    if(profile == selectedProfileState)
    {
	setState(true);
	qDebug() << "status je " << true ;
    }
    else
    {
	setState(false);
	qDebug() << "status je " <<  false;
    }

}

void CurrentProfile::load(const QByteArray &data)
{
	QDataStream stream(data);
	stream >> selectedProfileState;
	update();
}

QByteArray CurrentProfile::save() const
{
	QByteArray data;
	QDataStream stream(&data, QIODevice::WriteOnly);
	stream << selectedProfileState;
	return data;
}

Q_EXPORT_PLUGIN2(currentprofile, CurrentProfileInterface)
