/*************************************************************************************************
**
** file:    dynamic.js
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

var component;
var pluginGUI;

function createPluginGUI(type, name, parent) {
    component = Qt.createComponent(type == "actions" ? Profiler.actionPluginQmlGUI(name) : Profiler.conditionPluginQmlGUI(name));
    if (component.status == Component.Ready)
        finishCreation();
    else
        component.statusChanged.connect(finishCreation);
}

function finishCreation() {
    if (component.status == Component.Ready) {
        pluginGUI = component.createObject(parent);
        if (pluginGUI == null) {
            // Error Handling
        } else {

        }
    } else if (component.status == Component.Error) {
        // Error Handling
        console.log("Error loading component:", component.errorString());
    }
}
