/*
Copyright (c) 2012, Petr Pehal, Jakub Šplíchal, Rostislav Stríž,

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer
    in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*************************************************************************************************
**
** file:    DetailListView.qml
** date:    10.12.2011
** authors: Petr Pehal,      xpehal00@stud.fit.vutbr.cz
**          Rostislav Striz, xstriz03@stud.fit.vutbr.cz
**          Jakub Splichal,  xsplic03@stud.fit.vutbr.cz
**
**************************************************************************************************/

import Qt 4.7
import QtQuick 1.1
import Qt.labs.components.native 1.0

// main aplication viewer

Row {
    id: rootView
    x: 0
    state: "list"

    property bool clickToCloseDetails: true
    property int contentAreaWidth: parent.width

    property variant model
    property alias delegate: listView.delegate


    // STATE SWITCHING FUNCTIONS
    // switching between profile selection list and profile details
    function switchState() {
        if (state == "list") {
            state = "details"
        }
        else {
            state = "list"
        }
    }

    // switching between profile details and coverflow
    function switchState2() {
        if (state == "details") {
            state = "coverflow"
        }
        else {
            state = "details"
        }
    }


    // switching between profile details and plugin gui
    function switchState3() {
        if(state == "details") {
            state = "plugingui"
        }
        else {
            state = "details"
        }
    }
    // END OF STATE SWITCHING FUNCTIONS



    // Animate list state transition
    Behavior on x { NumberAnimation { duration: 200; easing.type: Easing.InOutCubic } }


    // MAIN LIST - profiles to choose + add
    ListView {
        id: listView

        width: contentAreaWidth

        model: rootView.model
        delegate: DetailListDelegate {}

        anchors.top: parent.top
        anchors.topMargin: 50
        anchors.bottom: parent.bottom

        property int selectedToDelete


        QueryDialog {
            id: qd
            titleText: "Delete profile"

            message: "Are you sure you want to delete this profile?";

            acceptButtonText: "Delete"
            rejectButtonText: "Cancel"
            onAccepted: {
                Profiler.removeProfile(listView.selectedToDelete)
            }
        }


        // TOP grey header - status + name + add new profile
        Rectangle {
            id: toprec

            height: 50
            width: parent.width

            anchors.top: parent.top
            anchors.topMargin: -50

            Image {
                anchors.fill: parent
                source: "qrc:/icons/toolbarheader.png"
            }

            // inside of header
            Row {
                anchors.verticalCenter: parent.verticalCenter
                Text {
//                    anchors.left: parent.left
//                    anchors.leftMargin: 22
                    font.pixelSize: 15
                    style: Text.Raised
                    text: "Active:"
                    color: "white"
                }
                Text {
//                    anchors.left: parent.left
//                    anchors.leftMargin: 95
                    font.pixelSize: 15
                    style: Text.Raised
                    text: "Name:"
                    color: "white"
                }
            }
        }// header end


        ScrollBar {
            flickable: listView
            vertical: true
        }

    }



    // DETAILS - profile details - list of cond + cons
    Rectangle {
        id: detailView

        width: contentAreaWidth

        anchors.top: parent.top
        anchors.bottom: parent.bottom

        color: "black"

        property int selectedToDelete

        QueryDialog {
            id: qdact
            titleText: "Delete action from profile"

            message: "Are you sure you want to delete selected action from this profile?";

            acceptButtonText: "Delete"
            rejectButtonText: "Cancel"
            onAccepted: {
                Profiler.removeCurrentProfileAction(detailView.selectedToDelete)
            }
        }


        QueryDialog {
            id: qdcond
            titleText: "Delete condition from profile"

            message: "Are you sure you want to delete selected condition from this profile?";

            acceptButtonText: "Delete"
            rejectButtonText: "Cancel"
            onAccepted: {
                Profiler.removeCurrentProfileCondition(detailView.selectedToDelete)
            }
        }

        // TOP - status text - active/nonactive
        Rectangle {
            height: 45
            width: parent.width

            z: 20

            anchors.top: parent.top
            anchors.topMargin: 10

            Image {
                anchors.fill: parent
                source: "qrc:/icons/toolbarheader.png"
            }


            // activity status light
            Image {
                id: detailViewPic
                width: 30
                height: 30

                anchors.verticalCenter: parent.verticalCenter
                anchors.left: parent.left
                anchors.leftMargin: 10
            }

            // inside of header - status text
            Text {
                id: detailViewStatus

                anchors.top: parent.top
                anchors.topMargin: 5
                anchors.left: parent.left
                anchors.leftMargin: 50

                font.pixelSize: 22
                color: "white"
            }

        }// header end



        // CONDITIONS - list
        Rectangle {
            width: 355
            height: 280

            anchors.top: parent.top
            anchors.topMargin: 70
            anchors.left: parent.left
            anchors.leftMargin: 15

            color: "black"

            border.color: "grey"
            border.width: 0

            // conditions list header
            Text {
                anchors.top: parent.top
                anchors.topMargin: 5
                anchors.left: parent.left
                anchors.leftMargin: 5

                text: "Conditions:"
                font.pixelSize: 25
                color: "silver"
                height: 42

                // add new button
                Image {
                    width: 43
                    height: 42

                    z: 20

                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    anchors.leftMargin: 300
                    anchors.top: parent.top

                    source: "qrc:/icons/add_big.png"

                    // clickable button
                    MouseArea {
                        anchors.fill: parent

                        onHoveredChanged: {
                            if(parent.source == "qrc:/icons/add_big_pressed.png")
                                parent.source = "qrc:/icons/add_big.png"
                            else
                                parent.source = "qrc:/icons/add_big_pressed.png"
                        }

                        onClicked: {
                            coverFlowViewCore.type = "conditions"
                            Profiler.listConditionPlugins()
                            detailListView.switchState2()
                        }
                    }

                }

            }// condition header end


            // condition list itself
            ListView {
                id: cond

                width: parent.width
                height: parent.height

                z: 0

                anchors.top: parent.top
                anchors.topMargin: 60
                anchors.left: parent.left
                anchors.leftMargin: 0

                model: ProfileConditions

                delegate: ConditionDelegate {}
            } // end of condition list

        } // end of condition gui




        // ACTIONS - list
        Rectangle {

            width: 355
            height: 280

            anchors.top: parent.top
            anchors.topMargin: 70
            anchors.left: parent.left
            anchors.leftMargin: 420

            color: "black"

            border.color: "grey"
            border.width: 0

            // actions list header
            Text {

                anchors.top: parent.top
                anchors.topMargin: 5
                anchors.left: parent.left
                anchors.leftMargin: 5

                font.pixelSize: 25
                height: 42

                z: 20

                color: "silver"

                text: "Actions:"

                // add new action button
                Image {
                    width: 43
                    height: 42

                    anchors.verticalCenter: parent.verticalCenter
                    anchors.left: parent.left
                    anchors.leftMargin: 300
                    anchors.top: parent.top

                    source: "qrc:/icons/add_big.png"

                    // clickable area
                    MouseArea {

                        anchors.fill: parent

                        onHoveredChanged: {
                            if(parent.source == "qrc:/icons/add_big_pressed.png")
                                parent.source = "qrc:/icons/add_big.png"
                            else
                                parent.source = "qrc:/icons/add_big_pressed.png"
                        }

                        onClicked: {
                            coverFlowViewCore.type = "actions"
                            Profiler.listActionPlugins()
                            detailListView.switchState2()
                        }
                    }

                }// button end
            }// end of actions list header


            // actions list itself
            ListView {

                id: cons

                z: 0

                width: parent.width
                height: parent.height

                anchors.top: parent.top
                anchors.topMargin: 60
                anchors.left: parent.left
                anchors.leftMargin: 0


                model: ProfileActions

                delegate: ActionDelegate {}
            } // list end

        }// end of actions list


    }// end of profile details view




    // COVERFLOW
    Rectangle {
        id: coverFlowView

        width: contentAreaWidth

        anchors.top: parent.top
        anchors.bottom: parent.bottom

        color: "black"

        Rectangle {
            height: 50
            width: parent.width

            anchors.top: parent.top
            anchors.topMargin: 15


            Image {
                anchors.fill: parent
                source: "qrc:/icons/toolbarheader.png"
            }

            // inside of header
            Row {
                anchors.verticalCenter: parent.verticalCenter
                Text {
//                    anchors.left: parent.left
//                    anchors.leftMargin: 22
                    font.pixelSize: 15
                    style: Text.Raised
                    text: "Select plugin:"
                    color: "white"
                }
            }
        }// header end

        // coverflow rec
        Rectangle {
            width: 680
            height: 280

            anchors.centerIn: parent

            color: "black"

            Text {
                id: myText
                anchors.bottom: parent.bottom
                anchors.horizontalCenter: parent.horizontalCenter
            }

            // coverflow element itself
            CoverFlow {
                id: coverFlowViewCore

                width: parent.width

                anchors.top: parent.top
                anchors.topMargin: 80
                anchors.bottom: myText.top

                color: "black"

                listModel: Plugins

                itemWidth: 250
                itemHeight: 250
            }

        }// end of coverflow rec
    }// end of coverflow view




    // PLUGIN GUI viewer
    Rectangle {
        id: pluginView

        objectName: "directPluginGUI"

        width: parent.width
        height: parent.height

        anchors.top: parent.top
        anchors.bottom: parent.bottom

        // plugin loader
        Loader {
            id: contentPluginLoader
            anchors.fill: parent
        }

        function loadPlugin(source)
        {
            contentPluginLoader.source = source
        }
    }// end of plugi gui viewer




    // GUI STATES
    states: [
        State {
            name: "list"
            PropertyChanges { target: detailListView; x: 0 }
        },
        State {
            name: "details"
            PropertyChanges { target: detailListView; x: -listView.width }
        },
        State {
            name: "coverflow"
            PropertyChanges { target: detailListView; x: -(listView.width * 2)}
        },
        State {
            name: "plugingui"
            PropertyChanges { target: detailListView; x: -(listView.width * 3)}
        }
    ]// end of states
}
