/*  
 *  Mancala Common Source Module -- mancala.c
 *  Kevin Riggle
 *  http://cmancala.sourceforge.net
 *  $Source: /cvsroot/cmancala/mancala/src/Attic/mancala.c,v $
 *  $Revision: 1.4.2.1 $
 *  $Date: 2003/12/29 05:49:52 $
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include "mancala.h"

/* Set up the game board. */
void gameInit(int *aiBoard, int *humanBoard) {

  int i;

  *aiBoard = *humanBoard = 0;

  for (i=1; i<=BOARD_MAX; i++)
    *(aiBoard + i) = *(humanBoard + i) = INITIAL_STONES;

}

/* Has the game been won by someone? */
int gameWon(int *aiBoard, int *humanBoard) {

  int aiTotal, humanTotal, i;

  aiTotal = humanTotal = 0;

  /* Sum the stones on each side... */
  for (i=1; i<=BOARD_MAX; i++) {
    aiTotal = aiTotal + *(aiBoard + i);
    humanTotal = humanTotal + *(humanBoard + i);
  }

  /* If one side has none, return accordingly. */
  if (aiTotal == 0 || humanTotal == 0) {
    /* Calculate the final score. */
    for (i=1; i<=BOARD_MAX; i++) {
      *aiBoard = *aiBoard + *(aiBoard + i);
      *humanBoard = *humanBoard + *(humanBoard + i);
      *(aiBoard + i) = *(humanBoard + i) = 0;
    }    
    return 1;
  }
  else
    return 0;

}

/* Make a move, and return the position of the last stone! */
int move(int *activeBoard, int *passiveBoard, int move) {

  int *currentPosition, stones;

  currentPosition = activeBoard + move;

  stones = *(activeBoard + move);
  if (stones > 0){
      /* Pick up the stones. */
      *(activeBoard + move) = 0;

      /* Loop for each stone. */
      for (; stones>0; stones--) {
              /* Move to the next board location. */
              if (currentPosition == activeBoard)
                      currentPosition = passiveBoard + BOARD_MAX;
              else if (currentPosition == passiveBoard + 1)
                      currentPosition = activeBoard + BOARD_MAX;
              else
                      currentPosition--;
              /* Drop a stone. */
              (*currentPosition)++;
      }
      
      /* If the last stone lands on an empty hole... */
      if (*currentPosition == 1 && activeBoard < currentPosition && 
              currentPosition <= (activeBoard + BOARD_MAX)) {
              /* ...calculate the position of the opposite hole... */
              int oppHole = (BOARD_MAX + 1) - (currentPosition - activeBoard);
              /* ...and make the capture. */
              *activeBoard = *activeBoard + *(passiveBoard + oppHole);
              printf("Captured %d stones.\n", *(passiveBoard + oppHole));
              *(passiveBoard + oppHole) = 0;
      }
      
      return currentPosition - activeBoard;
  }
  else{
      printf("move from empty hole...\n");
      /* return 0 so human can make a move again */
      return 0;
  }
   
}

int rand_btw(int min, int max) {

	int range;

	range = (max - min) + 1;

	return ((rand() % range) + min);

}
  
/*  End mancala.c  */
