/*  
 *  AI Testing Module -- ai-test.c
 *  Kevin Riggle
 *  http://cmancala.sourceforge.net
 *  $Source: /cvsroot/cmancala/mancala/src/Attic/ai-test.c,v $
 *  $Revision: 1.8.2.1 $
 *  $Date: 2003/12/29 05:49:52 $
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include "ai.h"
#include "mancala.h"

static void print_board(int *aiBoard, int *humanBoard);

int main(int argc, char **argv) {

  int *aiBoard, *humanBoard;
  int current_move, i;
  FILE *data;

  aiBoard = (int *) calloc(BOARD_MAX+1, sizeof(int));
  humanBoard = (int *) calloc(BOARD_MAX+1, sizeof(int));

  printf("Hello and welcome to the mancala ai-test program.\n");
  printf("If you liked these bugs, please check out http://cmancala.sourceforge.net\n");
  printf("for more fine specimens.  Thanks!  -kr\n");

  if ((argv[1] != NULL) && (argc == 2)) {
    if ((data = fopen((char *) argv[1], "r")) == NULL) {
      printf("Cannot open file %s...\n", (char *) argv[1]);
      return 1;
    }

    /* Store hypothetical board layouts to test AI with */
    for(i=0;i<=BOARD_MAX;i++) 
      if (fscanf(data, "%d", (aiBoard + i)) == EOF) {
		printf("Reached end of file...\n");
		return 1; 
	}

    for(i=0;i<=BOARD_MAX;i++)
      if (fscanf(data, "%d", (humanBoard + i)) == EOF) {
		printf("Reached end of file...\n");
		return 1;
	}

    fclose(data);
  }
  else if ((argv[1] != NULL) && (argc >= (BOARD_MAX*2 + 3))) {
  	for (i=0; i<=BOARD_MAX; i++)
		*(aiBoard + i) = **(argv + i + 1) - 48;
	for (i=0; i<=BOARD_MAX; i++)
		*(humanBoard + i) = **(argv + i + (BOARD_MAX+2)) - 48;
  }
  else {
 
  	for (i=0; i<=BOARD_MAX; i++) {
		printf("aiBoard[%d] = ", i);
		scanf("%d", &aiBoard[i]);
   	}
	for (i=0; i<=BOARD_MAX; i++) {
		printf("humanBoard[%d] = ", i);
		scanf("%d", &humanBoard[i]);
	}
  }

  free(aiBoard);
  free(humanBoard);

  print_board(aiBoard, humanBoard);

  /* Test it! */
  printf("Dave: Let's test out the AI!\n");
  if ((current_move = aiMove(aiBoard, humanBoard)) == 0)
    printf("HAL: I'm sorry, Dave.  I can't do that.\n");
  else {
    printf("HAL: All my circuits are operational.\n");
    printf("HAL: I'm going to move from hole %d.\n", current_move);
    printf("HAL: I'm sorry, Dave.  You've lost.\n");
  }

  /* AskIgor Testing 
  if (current_move == 1)
    printf("pass\n");
  else
    printf("fail\n");
  */

  return 0;

}


/* Print board layout to stdout. */
static void print_board(int *aiBoard, int *humanBoard) {
  int i;

  printf("\nHuman        AI\n");
  printf("       %d\n", *aiBoard);
  for (i=1; i<=BOARD_MAX; i++)
    printf("%d - %d     %d - %d\n", ((BOARD_MAX + 1) - i),
	   *(humanBoard + ((BOARD_MAX + 1) - i)), *(aiBoard + i), i);
  printf("       %d\n\n", *humanBoard);

}

/* End ai-test.c */
