###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

# pyqt modules
from PyQt4.QtGui import (QApplication, QLabel, QListView, QPushButton, 
                          QMainWindow, QMessageBox, QHBoxLayout, QVBoxLayout, QWidget)
from PyQt4.QtCore import (pyqtSignature, Qt)
import sip

# third-party modules
import config as c

# program modules 
from ui.ui_view_exercise_window import Ui_ViewExerciseWindow
import exercise_wizard as ew

class ViewExerciseWindow(QMainWindow, Ui_ViewExerciseWindow):

    def __init__(self, model, index, database=None, parent=None):
        super(ViewExerciseWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.db = database
        self.model = model
        self.index = index
        self.setupUi(self)
        self.setupValues()
        self.setupValueButtons()
        self.setWindowTitle("%s (%s)" %(self.ex_name, self.t_name))
        self.example_media_player.setFilename(self.filename)

        self.config = c.Config()
        self.reflowWidgets()

        QApplication.desktop().resized.connect(self.reflowWidgets)

    def setupValues(self):
        record = self.model.record(self.index.row())
        self.description = record.value('ex_description').toString()
        self.filename = record.value('ex_media').toString()
        self.ex_name = record.value('ex_name').toString()
        self.t_name = record.value('t_name').toString()
        self.f_name = record.value('f_name').toString()
        self.d_name = record.value('d_name').toString()
        self.i_name = record.value('i_name').toString()
        self.e_name = record.value('e_name').toString()
        self.ex_media = record.value('ex_media').toString()

    def setupValueButtons(self):
        self.frequency_value_button.setValueText(self.f_name)
        self.duration_value_button.setValueText(self.d_name)
        self.intensity_value_button.setValueText(self.i_name)
        self.equipment_value_button.setValueText(self.e_name)

    def reflowWidgets(self):
        try:
            sip.delete(self.central_widget.layout())
        except TypeError:
            pass

        screen_geometry = QApplication.desktop().screenGeometry()
        if screen_geometry.width() > screen_geometry.height():
            self.central_widget.setLayout(QVBoxLayout())

            top_h_box = QHBoxLayout()
            top_h_box.addWidget(self.example_media_player)

            bottom_h_box = QHBoxLayout()
            bottom_h_box.addWidget(self.duration_value_button)
            bottom_h_box.addWidget(self.frequency_value_button)
            bottom_h_box.addWidget(self.intensity_value_button)
            bottom_h_box.addWidget(self.equipment_value_button)

            self.central_widget.layout().addLayout(top_h_box)
            self.central_widget.layout().addLayout(bottom_h_box)
        else:
            self.central_widget.setLayout(QVBoxLayout())
            self.central_widget.layout().addWidget(self.example_media_player)
            self.central_widget.layout().addWidget(self.duration_value_button)
            self.central_widget.layout().addWidget(self.frequency_value_button)
            self.central_widget.layout().addWidget(self.intensity_value_button)
            self.central_widget.layout().addWidget(self.equipment_value_button)


    @pyqtSignature('bool')
    def on_description_action_triggered(self, checked):
        message_box = QMessageBox()
        message_box.setText(self.description)
        message_box.setWindowTitle('Description')
        message_box.exec_()

    @pyqtSignature('bool')
    def on_delete_action_triggered(self, checked):
        model = self.db.exercises_model(self.t_name)
        model.removeRow(self.index.row())
        self.parent().refreshModel()
        self.close()

    @pyqtSignature('bool')
    def on_edit_action_triggered(self, checked):
        exercise_wizard = ew.ExerciseWizard(self, self.db, self.ex_name)
        exercise_wizard.exercisesUpdated.connect(self.parent().refreshModel)
        exercise_wizard.setStartId(1)
        exercise_wizard.setWindowTitle('Edit Exercise')


        t_id = self.db.getRow('t_name', self.t_name)
        f_id = self.db.getRow('f_name', self.f_name)
        d_id = self.db.getRow('d_name', self.d_name)
        i_id = self.db.getRow('i_name', self.i_name)
        e_id = self.db.getRow('e_name', self.e_name)
        

        exercise_wizard.name_line_edit.setText(self.ex_name)
        exercise_wizard.description_text_edit.setHtml(self.description)
        exercise_wizard.target_area_selector.setCurrentIndex(t_id)
        exercise_wizard.frequency_selector.setCurrentIndex(f_id)
        exercise_wizard.duration_selector.setCurrentIndex(d_id)
        exercise_wizard.intensity_selector.setCurrentIndex(i_id)
        exercise_wizard.equipment_selector.setCurrentIndex(e_id)
        exercise_wizard.media_line_edit.setText(self.ex_media)

        exercise_wizard.show()
        self.close()
