###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

# pyqt modules
from PyQt4.QtGui import (QAbstractItemView, QInputDialog, QLineEdit, QMainWindow, 
                         QMenu, QPushButton)
from PyQt4.QtMaemo5 import QMaemo5EditBar
from PyQt4.QtCore import (pyqtSignature, Qt)


# third-party modules
import config as c

# program modules 
from ui.ui_target_areas_window import Ui_TargetAreasWindow
import sessions_window as ww
import exercises_window as ew

class TargetAreasWindow(QMainWindow, Ui_TargetAreasWindow):

    def __init__(self, parent=None, database=None):
        super(TargetAreasWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.setupEditBar()
        self.config = c.Config()
        self.db = database
        self.target_areas_list_view.setModel(self.db.target_areas_model)
        self.target_areas_list_view.setModelColumn(1)

        self.customContextMenuRequested.connect(self.openMenu)

    def setupEditBar(self):
        self.delete_button = QPushButton('Delete')
        self.edit_bar = QMaemo5EditBar('Select Target Areas', self)
        self.edit_bar.addButton(self.delete_button)
        self.edit_bar.setVisible(False)

        self.central_widget.layout().insertWidget(0, self.edit_bar)

    def closeEvent(self, event):
        if self.edit_bar.isVisible():
            self.exitFullScreen()
            event.ignore()
        else:
            event.accept()

    @pyqtSignature("QModelIndex")
    def on_target_areas_list_view_clicked(self, index):
        t_name = index.data().toString()
        filtered_exercises_window = ew.ExercisesWindow(self, self.db, t_name)
        filtered_exercises_window.show()

    @pyqtSignature("bool")
    def on_sessions_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'sessions'
        self.parent().setFitnessWindow()
        sessions_window = ww.SessionsWindow(self.parent(), self.db)
        sessions_window.show()
        self.hide()


    @pyqtSignature("bool")
    def on_exercises_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'exercises'
        self.parent().setFitnessWindow()
        exercises_window = ew.ExercisesWindow(self.parent(), self.db)
        exercises_window.show()
        self.hide()

    @pyqtSignature('bool')
    def on_delete_target_areas_action_triggered(self, checked):
        self.target_areas_list_view.blockSignals(True)
        def deleteTargetAreas():
            indexes = []
            for index in self.target_areas_list_view.selectedIndexes():
                try:
                    if index.row() > indexes[-1].row():
                        indexes.insert(0, index)
                    else:
                        indexes.append(index)
                except IndexError:
                    indexes.append(index)

            for index in indexes:
                self.db.target_areas_model.removeRow(index.row())

            self.exitFullScreen()

        self.target_areas_list_view.setSelectionMode(QAbstractItemView.MultiSelection)
        self.edit_bar.setVisible(True)
        self.new_target_area_button.setVisible(False)

        self.showFullScreen()

        self.delete_button.clicked.connect(deleteTargetAreas)

    def exitFullScreen(self):
        self.target_areas_list_view.clearSelection()
        self.target_areas_list_view.setSelectionMode(QAbstractItemView.SingleSelection)
        self.new_target_area_button.setVisible(True)
        self.edit_bar.setVisible(False)
        self.showNormal()
        self.target_areas_list_view.blockSignals(False)

    def on_new_target_area_button_pressed(self):
        def updateTName(text):
            global t_name
            t_name = text

        def addTargetArea():
            global t_name
            self.db.editTargetArea(t_name)

        dialog = QInputDialog(self)
        dialog.setWindowTitle('New Target Area')
        dialog.setLabelText('Name:')
        dialog.setOkButtonText('Save')
        t_name = None
        
        dialog.textValueChanged.connect(updateTName)
        dialog.accepted.connect(addTargetArea)
        dialog.show()


    def openMenu(self, position):
        menu = QMenu(self)
        edit_action = menu.addAction('Edit')
        delete_action = menu.addAction('Delete')

        action = menu.exec_(self.mapToGlobal(position))

        if action == edit_action:
            def updateTName(text):
                global t_name

                t_name = text

            def editTargetArea():
                self.db.editTargetArea(t_name, old_name)

            index = self.target_areas_list_view.currentIndex()
            dialog = QInputDialog(self)
            dialog.setWindowTitle('Edit Target Area')
            dialog.setLabelText('New Name:')
            dialog.setOkButtonText('Save')
            dialog.setTextValue(index.data().toString())

            t_name = None
            old_name = dialog.textValue()

            dialog.textValueChanged.connect(updateTName)
            dialog.accepted.connect(editTargetArea)
            dialog.show()
        elif action == delete_action:
            self.db.target_areas_model.removeRow(
                              self.target_areas_list_view.currentIndex().row())
