###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

# pyqt modules
from PyQt4.QtGui import (QMainWindow, QListView, QMenu)
from PyQt4.QtCore import (pyqtSignature, pyqtSignal, Qt)

# program modules 
from ui.ui_target_areas_window import Ui_TargetAreasWindow
from ui.ui_session_window import Ui_SessionWindow
import exercises_window as ew
import exercises_dialog as ed

class SessionWindow(QMainWindow, Ui_SessionWindow):

    def __init__(self, s_name, s_id, parent=None, database=None):
        super(SessionWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.setWindowTitle(s_name)
        self.db = database
        self.s_id = s_id
        self.s_name = s_name
        self.setupSessionExercisesListView()

        self.customContextMenuRequested.connect(self.openMenu)

    def setupSessionExercisesListView(self):
        self.model = self.db.session_exercises_model(self.s_name)
        self.session_exercises_list_view.setModel(self.model)
        self.session_exercises_list_view.setModelColumn(1)

    def openMenu(self, position):
        menu = QMenu(self)
        delete_action = menu.addAction('Delete')

        action = menu.exec_(self.mapToGlobal(position))

        if action == delete_action:
            index = self.session_exercises_list_view.currentIndex()
            re_id = index.model().record(index.row()).value('re_id').toString()
            self.db.removeSessionExercise(re_id)
            self.setupSessionExercisesListView()


    @pyqtSignature("bool")
    def on_add_exercises_action_triggered(self, checked):

        self.exercises_dialog = ed.ExercisesDialog(self, self.db)
        self.exercises_dialog.show()
        self.exercises_dialog.accepted.connect(self.addSessionExercises)

    def addSessionExercises(self):
        ex_ids = []
        for index in self.exercises_dialog.exercises_list_view.selectedIndexes():
            ex_ids.append(index.model().record(index.row()).value('ex_id').toString())

        for ex_id in ex_ids:
            self.db.editSessionExercise(self.s_id, ex_id)

        self.setupSessionExercisesListView()
