# pyqt modules
from PyQt4.QtGui import (QDialog)
from PyQt4.QtCore import (pyqtSignal)

# program modules
from ui.ui_session_dialog import Ui_SessionDialog

class SessionDialog(QDialog, Ui_SessionDialog):

    def __init__(self, parent=None, database=None, old_name=None):
        super(SessionDialog, self).__init__(parent)

        self.setupUi(self)
        if old_name:
            self.old_name = old_name
            self.setWindowTitle('Edit Session')
        else:
            self.old_name = None
            self.setWindowTitle('Create Session')

        self.db = database

    def on_button_box_accepted(self):
        s_name = self.name_line_edit.text()
        s_description = self.description_text_edit.toPlainText() or None
        self.db.editSession(s_name, s_description, self.old_name)
