# builtin modules
import sys

# pyqt modules
from PyQt4.phonon import Phonon
from PyQt4.QtGui import (QApplication)
from PyQt4.QtCore import (Qt, SIGNAL)

class ExampleMediaPlayer(Phonon.VideoPlayer):

    def __init__(self, parent=None):
        super(ExampleMediaPlayer, self).__init__(parent)
        self.filename = None

    def setFilename(self, filename):
        self.filename = filename
        self.load(Phonon.MediaSource(filename))

    def mouseReleaseEvent(self, event):
        if self.isFullScreen():
            self.setWindowFlags(Qt.Widget)
            self.showNormal()
            if self.mediaObject().state() == Phonon.StoppedState:
                self.play()
            else:
                self.stop()
        elif self.filename is not None:
            self.setWindowFlags(Qt.Window)
            self.showFullScreen()
            self.play()


if __name__ == '__main__':
    app = QApplication(sys.argv)
    app.setApplicationName('MaeGym')
    example = ExampleMediaPlayer()
    example.setFilename('http://www.quintic.com/education/case_studies_videos/Flat_Bench_SV.avi')
    sys.exit(app.exec_())
