# pyqt modules
from PyQt4.QtGui import (QDialog)
from PyQt4.QtCore import (pyqtSignal)

# program modules
from ui.ui_routine_dialog import Ui_RoutineDialog

class RoutineDialog(QDialog, Ui_RoutineDialog):

    def __init__(self, parent=None, database=None, old_name=None):
        super(RoutineDialog, self).__init__(parent)

        self.setupUi(self)
        if old_name:
            self.old_name = old_name
            self.setWindowTitle('Edit Routine')
        else:
            self.old_name = None
            self.setWindowTitle('Create Routine')

        self.db = database

    def on_button_box_accepted(self):
        r_name = self.name_line_edit.text()
        r_description = self.description_text_edit.toPlainText() or None
        self.db.editRoutine(r_name, r_description, self.old_name)
