###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

# pyqt modules
from PyQt4.QtGui import (QApplication, QLabel, QPushButton, 
                          QMainWindow, QMenu, QVBoxLayout, QWidget)
from PyQt4.QtCore import (Qt, pyqtSignature)

# third-party modules
import config as c 

# program modules 
from ui.ui_routines_window import Ui_RoutinesWindow
import exercises_window  as ew
import target_areas_window as taw
import routine_window as rw
import routine_dialog as rd

class RoutinesWindow(QMainWindow, Ui_RoutinesWindow):

    def __init__(self, parent=None, database=None):
        super(QMainWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.config = c.Config()
        self.db = database
        self.setupListView()

        self.customContextMenuRequested.connect(self.openMenu)

    def setupListView(self):
        self.model = self.db.routines_model
        self.routines_list_view.setModel(self.model)
        self.routines_list_view.setModelColumn(1)

    @pyqtSignature("bool")
    def on_exercises_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'exercises'
        self.parent().setFitnessWindow()
        exercises_window = ew.ExercisesWindow(self.parent(), self.db)
        exercises_window.show()
        self.hide()

    @pyqtSignature("bool")
    def on_target_areas_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'target_areas'
        self.parent().setFitnessWindow()
        target_areas_window = taw.TargetAreasWindow(self.parent(), self.db)
        target_areas_window.show()
        self.hide()

    @pyqtSignature('QModelIndex')
    def on_routines_list_view_clicked(self, index):
        r_name = index.data().toString()
        r_id = index.row()
        r_id = index.model().record(index.row()).field('r_id').value().toString()
        routine_window = rw.RoutineWindow(r_name, r_id, self, self.db)
        routine_window.show()

    def on_new_routine_button_pressed(self):
        routine_dialog = rd.RoutineDialog(self, self.db)
        routine_dialog.show()

    def openMenu(self, position):
        menu = QMenu(self)
        edit_action = menu.addAction('Edit')
        delete_action = menu.addAction('Delete')

        action = menu.exec_(self.mapToGlobal(position))

        if action == edit_action:
            index = self.routines_list_view.currentIndex()
            name = self.model.record(index.row()).value('r_name')

            routine_dialog = rd.RoutineDialog(self, self.db, name)

            description = self.model.record(index.row()).value('r_description')

            routine_dialog.name_line_edit.setText(name.toString())
            routine_dialog.description_text_edit.setHtml(description.toString())
            routine_dialog.show()
        elif action == delete_action:
            self.model.removeRow(self.routines_list_view.currentIndex().row())

