###############################################################################
# copyright 2010 Edwin Marshall (aspidites) <aspidties@inbox.com>             #
#                                                                             #
# This file is part of MaeGym                                                 #
#                                                                             #
# MaeGym is free software: you can redistribute it and/or                     #
# modify it under the terms of the GNU General Public License as published by #
# the Free Software Foundation, either version 3 of the License, or           #
# (at your option) any later version.                                         #
#                                                                             #
# MaeGym is distributed in the hope that it will be useful,                   #
# but WITHOUT ANY WARRANTY; without even the implied warranty of              #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
# GNU General Public License for more details.                                #
#                                                                             #
# You should have received a copy of the GNU General Public License           #
# along with MaeGym.                                                          # 
# If not, see <http://www.gnu.org/licenses/>.                                 #
###############################################################################

# pyqt modules
from PyQt4.QtGui import (QApplication, QFileDialog, QStandardItem,
                         QStandardItemModel, QWizard)
from PyQt4.QtCore import (pyqtSignature, Qt, pyqtSignal)
from PyQt4.QtMaemo5 import (QMaemo5ListPickSelector, QMaemo5ValueButton)
import sip

# third-party modules
import config as c

# program modules 
from ui.ui_exercise_wizard import Ui_ExerciseWizard

class ExerciseWizard(QWizard, Ui_ExerciseWizard):
    #TODO: enforce referential integrety (required fields, etc)

    exercisesUpdated = pyqtSignal()

    def __init__(self, parent=None, database=None, old_name=None):
        super(ExerciseWizard, self).__init__(parent)

        self.setupUi(self)
        self.old_name = old_name
        self.db = database
        self.setupValueButtons()
        self.loadConfigOptions()
        self.reflowWidgets()

        self.accepted.connect(self.updateExercises)

        QApplication.desktop().resized.connect(self.reflowWidgets)


    def setupValueButtons(self):
        self.target_area_selector = QMaemo5ListPickSelector()
        self.target_area_selector.setModel(self.db.target_areas_model)
        self.target_area_selector.setModelColumn(1)
        self.target_area_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.target_area_value_button.setPickSelector(self.target_area_selector)

        self.frequency_selector = QMaemo5ListPickSelector()
        self.frequency_selector.setModel(self.db.frequencies_model)
        self.frequency_selector.setModelColumn(1)
        self.frequency_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.frequency_value_button.setPickSelector(self.frequency_selector)
        
        self.frequency_selector.selected.connect(self.updateSelectors)

        self.duration_selector = QMaemo5ListPickSelector()
        self.duration_selector.setModel(self.db.durations_model)
        self.duration_selector.setModelColumn(1)
        self.duration_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.duration_value_button.setPickSelector(self.duration_selector)

        self.intensity_selector = QMaemo5ListPickSelector()
        self.intensity_selector.setModel(self.db.intensities_model)
        self.intensity_selector.setModelColumn(1)
        self.intensity_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.intensity_value_button.setPickSelector(self.intensity_selector)

        self.equipment_selector = QMaemo5ListPickSelector()
        self.equipment_selector.setModel(self.db.equipment_model)
        self.equipment_selector.setModelColumn(1)
        # None
        self.equipment_selector.setCurrentIndex(5)
        self.equipment_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.equipment_value_button.setPickSelector(self.equipment_selector)

    def updateExercises(self):
        ex_name = self.name_line_edit.text()
        ex_description = self.description_text_edit.toPlainText()

        index = self.target_area_selector.currentIndex()
        record = self.db.target_areas_model.record(index)
        t_id = record.value('t_id')
        
        index = self.frequency_selector.currentIndex()
        record = self.db.frequencies_model.record(index)
        f_id = record.value('f_id')

        index = self.duration_selector.currentIndex()
        record = self.db.durations_model.record(index)
        d_id = record.value('d_id')

        index = self.intensity_selector.currentIndex()
        record = self.db.intensities_model.record(index)
        i_id = record.value('i_id')

        index = self.equipment_selector.currentIndex()
        record = self.db.equipment_model.record(index)
        e_id = record.value('e_id')

        ex_media = self.media_line_edit.text() or None
        
        self.db.editExercise(ex_name, ex_description, t_id, f_id, 
                             d_id, i_id, e_id, ex_media, self.old_name)

        self.exercisesUpdated.emit()

    def loadConfigOptions(self):
        self.config = c.Config()
        self.setOrientation()

    def setOrientation(self):
        if self.config.interface['orientation'].lower() == 'auto':
            self.setAttribute(Qt.WA_Maemo5AutoOrientation)
        elif self.config.interface['orientation'].lower() == 'landscape':
            self.setAttribute(Qt.WA_Maemo5LandscapeOrientation)
        elif self.config.interface['orientation'].lower() == 'portrait':
            self.setAttribute(Qt.WA_Maemo5PortraitOrientation)

    def reflowWidgets(self):
        screen_geometry = QApplication.desktop().screenGeometry()
        #TODO: Figure out how to get buttons to layout horizontally portrait
        if screen_geometry.height() > screen_geometry.width():
            pass

    def updateSelectors(self, text):
        if text == 'Circuits':
            # Laps
            self.duration_selector.setCurrentIndex(1)
            # Percentage
            self.intensity_selector.setCurrentIndex(0)
        elif text == 'Sets':
            # Reps
            self.duration_selector.setCurrentIndex(2)
            # Weight
            self.intensity_selector.setCurrentIndex(1)
        elif text == 'Time':
            # Time
            self.duration_selector.setCurrentIndex(3)
            # Percentage
            self.intensity_selector.setCurrentIndex(0)

    def on_open_button_released(self):
        filename = QFileDialog.getOpenFileName(self, 'Select Example Media',
                                               '/home/user/MyDocs/')
        self.media_line_edit.setText(filename)
