# builtin modules
import sys

# pyqt modules
from PyQt4.QtGui import (QApplication, QLabel, QListView, QPushButton, 
                          QMainWindow, QHBoxLayout, QVBoxLayout, QWidget)
from PyQt4.QtCore import (pyqtSignature, Qt, SIGNAL)
import sip

# third-party modules
import config as c

# program modules 
from ui.ui_view_exercise_window import Ui_ViewExerciseWindow

class ViewExerciseWindow(QMainWindow, Ui_ViewExerciseWindow):

    def __init__(self, parent=None, database=None):
        super(ViewExerciseWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.config = c.Config()
        self.db = database
        self.reflowWidgets()

        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), 
                     self.reflowWidgets)

    def reflowWidgets(self):
        try:
            sip.delete(self.central_widget.layout())
        except TypeError:
            pass

        screen_geometry = QApplication.desktop().screenGeometry()
        if screen_geometry.width() > screen_geometry.height():
            self.central_widget.setLayout(QVBoxLayout())

            top_h_box = QHBoxLayout()
            top_h_box.addWidget(self.example_media_player)

            bottom_h_box = QHBoxLayout()
            bottom_h_box.addWidget(self.duration_value_button)
            bottom_h_box.addWidget(self.frequency_value_button)
            bottom_h_box.addWidget(self.intensity_value_button)
            bottom_h_box.addWidget(self.equipment_value_button)

            self.central_widget.layout().addLayout(top_h_box)
            self.central_widget.layout().addLayout(bottom_h_box)

            """
            left_v_box = QVBoxLayout()
            left_v_box.addWidget(self.example_media_player)
            
            right_v_box = QVBoxLayout()
            right_v_box.addWidget(self.duration_value_button)
            right_v_box.addWidget(self.frequency_value_button)
            right_v_box.addWidget(self.intensity_value_button)
            right_v_box.addWidget(self.equipment_value_button)

            self.central_widget.layout().addLayout(left_v_box)
            self.central_widget.layout().addLayout(right_v_box)
            """
        else:
            self.central_widget.setLayout(QVBoxLayout())


            self.central_widget.layout().addWidget(self.example_media_player)
            self.central_widget.layout().addWidget(self.duration_value_button)
            self.central_widget.layout().addWidget(self.frequency_value_button)
            self.central_widget.layout().addWidget(self.intensity_value_button)
            self.central_widget.layout().addWidget(self.equipment_value_button)
