# pyqt modules
from PyQt4.QtGui import (QDialog, QStandardItem,  QStandardItemModel)
from PyQt4.QtCore import (pyqtSignature, Qt, SIGNAL)
from PyQt4.QtMaemo5 import (QMaemo5ListPickSelector, QMaemo5ValueButton)

# third-party modules
import config as c

# program modules 
from ui.ui_settings_dialog import Ui_SettingsDialog

class SettingsDialog(QDialog, Ui_SettingsDialog):

    def __init__(self, parent=None):
        super(SettingsDialog, self).__init__(parent)
        self.config = c.Config()

        self.setupUi(self)
        self.setupOrientationValueButton()
        self.setupRememberLastFitnessCheckbox()

    def setupOrientationValueButton(self):
        self.orientation_model = QStandardItemModel(3, 1)

        auto = QStandardItem("Auto")
        self.orientation_model.setItem(0, 0, auto)

        portrat = QStandardItem("Portrait")
        self.orientation_model.setItem(1, 0, portrat)

        landscape = QStandardItem("Landscape")
        self.orientation_model.setItem(2, 0, landscape)

        self.selector = QMaemo5ListPickSelector()
        self.selector.setModel(self.orientation_model)

        self.orientation_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.orientation_value_button.setPickSelector(self.selector)
        self.orientation_value_button.setValueText(self.config.interface['orientation'].capitalize())

    def setupRememberLastFitnessCheckbox(self):
        if self.config.interface['remember-last-fitness']:
            self.remember_last_fitness_checkbox.setCheckState(Qt.Checked)
        else:
            self.remember_last_fitness_checkbox.setCheckState(Qt.Unchecked)
            self.config.interface['last-fitness'] = 'exercises'

    def on_button_box_accepted(self):
        self.config.interface['orientation'] = self.selector.currentValueText()
        self.parent().setOrientation()
        self.close()

    @pyqtSignature("int")
    def on_remember_last_fitness_checkbox_stateChanged(self, state):
        if state:
            self.config.interface['remember-last-fitness'] = 'Yes'
        else:
            self.config.interface['remember-last-fitness'] = 'No'
            self.config.interface['last-fitness'] = 'exercises'
