# builtin modules
import sys

# pyqt modules
from PyQt4.QtGui import (QInputDialog, QLineEdit, QMainWindow, QMenu)
from PyQt4.QtCore import (pyqtSignature, Qt, SIGNAL)

# third-party modules
import config as c

# program modules 
from database import Database
from ui.ui_target_areas_window import Ui_TargetAreasWindow
import routines_window as ww
import exercises_window as ew

class TargetAreasWindow(QMainWindow, Ui_TargetAreasWindow):

    def __init__(self, parent=None, database=None):
        super(TargetAreasWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.config = c.Config()
        self.db = database
        self.target_areas_list_view.setModel(self.db.target_areas_model)
        self.target_areas_list_view.setModelColumn(1)

        self.customContextMenuRequested.connect(self.openMenu)

    @pyqtSignature("QModelIndex")
    def on_target_areas_list_view_clicked(self, index):
        t_name = self.db.target_areas_model.record(index.row()).value('t_name').toString()

        filtered_exercises_window = ew.ExercisesWindow(self, self.db, t_name)
        filtered_exercises_window.show()

    @pyqtSignature("bool")
    def on_routines_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'routines'
        self.parent().setFitnessWindow()
        routines_window = ww.RoutinesWindow(self.parent(), self.db)
        routines_window.show()
        self.hide()


    @pyqtSignature("bool")
    def on_exercises_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'exercises'
        self.parent().setFitnessWindow()
        exercises_window = ew.ExercisesWindow(self.parent(), self.db)
        exercises_window.show()
        self.hide()

    def on_new_target_area_button_pressed(self):
        def updateTName(text):
            global t_name

            t_name = text

        def addTargetArea():
            global t_name

            self.db.addTargetArea(t_name)

        dialog = QInputDialog(self)
        dialog.setWindowTitle('New Target Area')
        dialog.setLabelText('Name:')
        dialog.setOkButtonText('Save')
        t_name = None
        
        self.connect(dialog, SIGNAL('textValueChanged(QString)'),
                     updateTName)

        self.connect(dialog, SIGNAL('accepted()'), addTargetArea)
        dialog.show()


    def openMenu(self, position):
        menu = QMenu(self)
        edit_action = menu.addAction('Edit')
        delete_action = menu.addAction('Delete')

        action = menu.exec_(self.mapToGlobal(position))

        if action == edit_action:
            def updateTName(text):
                global t_name

                t_name = text

            def editTargetArea():
                self.db.editTargetArea(t_name, old_name)

            index = self.target_areas_list_view.currentIndex()
            dialog = QInputDialog(self)
            dialog.setWindowTitle('Edit Target Area')
            dialog.setLabelText('New Name:')
            dialog.setOkButtonText('Save')
            dialog.setTextValue(index.data().toString())

            t_name = None
            old_name = dialog.textValue()

            self.connect(dialog, SIGNAL('textValueChanged(QString)'),
                         updateTName)

            self.connect(dialog, SIGNAL("accepted()"), editTargetArea)

            dialog.show()
        elif action == delete_action:
            self.db.target_areas_model.removeRow(
                              self.target_areas_list_view.currentIndex().row())
