# builtin modules
import sys

# pyqt modules
from PyQt4.QtGui import (QApplication, QLabel, QPushButton, 
                          QMainWindow, QVBoxLayout, QWidget)
from PyQt4.QtCore import (pyqtSignature, Qt, SIGNAL)

# third-party modules
import config as c 

# program modules 
from ui.ui_routines_window import Ui_RoutinesWindow
import exercises_window  as ew
import target_areas_window as taw

class RoutinesWindow(QMainWindow, Ui_RoutinesWindow):

    def __init__(self, parent=None, database=None):
        super(QMainWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)

        self.config = c.Config()
        self.db = database

    @pyqtSignature("bool")
    def on_exercises_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'exercises'
        self.parent().setFitnessWindow()
        exercises_window = ew.ExercisesWindow(self.parent(), self.db)
        exercises_window.show()
        self.hide()

    @pyqtSignature("bool")
    def on_target_areas_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'target_areas'
        self.parent().setFitnessWindow()
        target_areas_window = taw.TargetAreasWindow(self.parent(), self.db)
        target_areas_window.show()
        self.hide()
