# builtin modules
import sys

# pyqt modules
from PyQt4.QtGui import (QMainWindow)
from PyQt4.QtCore import (pyqtSignature, Qt, SIGNAL)

# third-party modules
import config as c

# program modules 
from database import Database
from ui_target_areas_window import Ui_TargetAreasWindow
import workouts_window as ww
import exercises_window as ew
import filtered_exercises_window as few

class TargetAreasWindow(QMainWindow, Ui_TargetAreasWindow):

    def __init__(self, parent=None, database=None):
        super(TargetAreasWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.config = c.Config()
        self.db = database
        self.target_areas_list_view.setModel(self.db.target_areas_model)
        self.target_areas_list_view.setModelColumn(1)

    @pyqtSignature("bool")
    def on_workouts_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'workouts'
        workouts_window = ww.WorkoutsWindow(self.parent(), self.db)
        workouts_window.show()
        self.hide()

    @pyqtSignature("QModelIndex")
    def on_target_areas_list_view_clicked(self, index):
        id = self.db.target_areas_model.record(index.row()).value("t_id").toString()
        name = self.db.target_areas_model.record(index.row()).value("t_name").toString()
        self.db.filtered_exercises_model.setFilter("t_id=%s" % id)
        self.db.filtered_exercises_model.select()

        filtered_exercises_window = few.FilteredExercisesWindow(self, self.db)
        filtered_exercises_window.setWindowTitle(name)
        filtered_exercises_window.show()

    @pyqtSignature("bool")
    def on_exercises_action_triggered(self, checked):
        self.config.interface['last-fitness'] = 'exercises'
        exercises_window = ew.ExercisesWindow(self.parent(), self.db)
        exercises_window.show()
        self.hide()
