# builtin modules
import sys

# pyqt modules
from PyQt4.QtGui import (QMainWindow)
from PyQt4.QtCore import (pyqtSignature, Qt, SIGNAL)

# third-party modules
import config as c

# program modules 
from database import Database
from ui_filtered_exercises_window import Ui_FilteredExercisesWindow

class FilteredExercisesWindow(QMainWindow, Ui_FilteredExercisesWindow):

    def __init__(self, parent=None, database=None):
        super(FilteredExercisesWindow, self).__init__(parent)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)

        self.setupUi(self)
        self.config = c.Config()
        self.db = database
        self.filtered_exercises_list_view.setModel(self.db.filtered_exercises_model)
        self.filtered_exercises_list_view.setModelColumn(1)
