# builtin modules
import sys

# pyqt modules
from PyQt4.phonon import Phonon
from PyQt4.QtGui import (QApplication)
from PyQt4.QtCore import (QTimer, SIGNAL)

class ExampleMediaPlayer(Phonon.VideoPlayer):

    def __init__(self, parent=None):
        super(ExampleMediaPlayer, self).__init__(parent)
        self.filename = None

    def setFilename(self, filename):
        self.filename = filename
        self.load(Phonon.MediaSource(filename))

    def mouseReleaseEvent(self, event):
        if self.isFullScreen():
            self.showNormal()
            if self.mediaObject().state() == Phonon.StoppedState:
                self.play()
            else:
                self.stop()
        elif self.filename is not None:
            self.showFullScreen()
            self.play()


if __name__ == '__main__':
    app = QApplication(sys.argv)
    app.setApplicationName('MaeGym')
    demo_widget = DemoWidget()
    demo_widget.show()
    sys.exit(app.exec_())
