# builtin modules
import sys

# qt modules
from PyQt4.QtSql import (QSqlDatabase, QSqlQuery, QSqlTableModel)
from PyQt4.QtGui import (QProgressDialog)
from PyQt4.QtCore import (QVariant, Qt)

# my modules 
from config import Config
from models import ExercisesTableModel

reload(sys)
sys.setdefaultencoding('utf-8')

class Database(object):
    """PyQt version of database."""
    def __init__(self, parent=None):
        self.config = Config()

        self.parent = parent
        self.db = QSqlDatabase.addDatabase('QSQLITE')
        self.db.setDatabaseName(self.config.user_db_file)
        self.db.open()

        if self.config.general['first-run']:
            self.createProgressBarDialog()
            self.createTables()
            self.fillTables()
            self.progress_bar_dialog.close()
            self.config.general['first-run'] = False

        self.createTableModels()

    def createProgressBarDialog(self):
        self.progress_bar_dialog = QProgressDialog('Creating database. Please wait..',
                                                   'Stop', 0, 100, self.parent)
        self.progress_bar_dialog.setWindowTitle('MaeGym')
        if self.config.interface['orientation'] == 'Portrait':
            self.progress_bar_dialog.setAttribute(Qt.WA_Maemo5PortraitOrientation)
        elif self.config.interface['orientation'] == 'Landscape':
            self.progress_bar_dialog.setAttribute(Qt.WA_Maemo5LandscapeOrientation)
        elif self.config.interface['orientation'] == 'Auto':
            self.progress_bar_dialog.setAttribute(Qt.WA_Maemo5AutoOrientation)
        self.progress_bar_dialog.setWindowModality(Qt.WindowModal)
        self.progress_bar_dialog.show()


    def createTables(self):
        self.progress_bar_dialog.setValue(0)
        query = QSqlQuery()
        query.exec_("""CREATE TABLE IF NOT EXISTS target_areas (
                            t_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
                            t_name TEXT COLLATE NOCASE NOT NULL)""")
        self.progress_bar_dialog.setValue(5)
        query.exec_("""CREATE TABLE IF NOT EXISTS frequencies (
                            f_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
                            f_name TEXT COLLATE NOCASE NOT NULL)""")
        self.progress_bar_dialog.setValue(10)
        query.exec_("""CREATE TABLE IF NOT EXISTS intensities (
                            i_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
                            i_name TEXT COLLATE NOCASE NOT NULL)""")
        self.progress_bar_dialog.setValue(15)
        query.exec_("""CREATE TABLE IF NOT EXISTS durations (
                            d_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
                            d_name TEXT COLLATE NOCASE NOT NULL)""")
        self.progress_bar_dialog.setValue(20)
        query.exec_("""CREATE TABLE IF NOT EXISTS equipment (
                            e_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
                            e_name TEXT COLLATE NOCASE NOT NULL)""")
        self.progress_bar_dialog.setValue(25)
        query.exec_("""CREATE TABLE IF NOT EXISTS exercises (
                            ex_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
                            ex_name TEXT COLLATE NOCASE NOT NULL,
                            ex_description TEXT COLLATE NOCASE,
                            t_id INTEGER NOT NULL,
                            f_id INTEGER NOT NULL,
                            i_id INTEGER NOT NULL,
                            d_id INTEGER NOT NULL,
                            e_id INTEGER,
                            ex_media TEXT,
                            FOREIGN KEY(t_id) REFERENCES target_areas(t_id),
                            FOREIGN KEY(f_id) REFERENCES frequencies(f_id),
                            FOREIGN KEY(i_id) REFERENCES intensities(i_id),
                            FOREIGN KEY(d_id) REFERENCES durations(d_id)
                            FOREIGN KEY(e_id) REFERENCES equipment(e_id))""")
        self.progress_bar_dialog.setValue(35)
        query.exec_("""CREATE TABLE IF NOT EXISTS workouts(
                            w_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
                            w_name TEXT COLLATE NOCASE NOT NULL,
                            w_description TEXT COLLATE NOCASE,
                            e_id,
                            FOREIGN KEY(e_id) REFERENCES exercises(e_id))""")
        self.progress_bar_dialog.setValue(40)
        query.exec_("""CREATE TABLE IF NOT EXISTS calendar (
                            c_id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
                            c_name TEXT COLLATE NOCASE NOT NULL,
                            date DATETIME,
                            w_id,
                            FOREIGN KEY(w_id) REFERENCES workouts(w_id))""")
        self.db.commit()
        self.progress_bar_dialog.setValue(45)

    def fillTables(self):
        query = QSqlQuery()
        query.prepare("""INSERT OR IGNORE INTO target_areas
                         (t_name) VALUES (?)""")

        for t_name in ("Abdominals", "Aerobic", "Biceps", "Calves", "Cardio", 
                       "Chest", "Fat Burn", "Forearms", "Glutes", 
                       "Hamstrings", "Lats", "Lower Back", "Middle Back", 
                       "Neck", "Other", "Quadriceps", "Shoulders", "Traps", 
                       "Triceps"):
            query.addBindValue(QVariant(t_name))
            query.exec_()

        self.db.commit()
        self.progress_bar_dialog.setValue(55)

        query.prepare("""INSERT OR IGNORE INTO durations
                         (d_name) VALUES (?)""")

        for d_name in ("Distance", "Laps", "Reps", "Time"):
            query.addBindValue(QVariant(d_name))
            query.exec_()

        self.db.commit()
        self.progress_bar_dialog.setValue(65)

        query.prepare("""INSERT OR IGNORE INTO frequencies
                         (f_name) VALUES (?)""")

        for f_name in ("Circuits", "Sets", "Time"):
            query.addBindValue(QVariant(f_name))
            query.exec_()

        self.db.commit()
        self.progress_bar_dialog.setValue(75)

        query.prepare("""INSERT OR IGNORE INTO intensities
                         (i_name) VALUES (?)""")

        for i_name in ("Percentage", "Weight"):
            query.addBindValue(QVariant(i_name))
            query.exec_()

        self.db.commit()
        self.progress_bar_dialog.setValue(85)

        query.prepare("""INSERT OR IGNORE INTO equipment
                         (e_name) VALUES (?)""")

        for e_name in ("Barbell", "Cable", "Dumbbell", "Exercise Ball", 
                       "Machine", "Other", "None"):
            query.addBindValue(QVariant(e_name))
            query.exec_()

        self.db.commit()
        self.progress_bar_dialog.setValue(100)

    def createTableModels(self):
        self.target_areas_model = QSqlTableModel()
        self.target_areas_model.setTable("target_areas")
        self.target_areas_model.select()

        self.durations_model = QSqlTableModel()
        self.durations_model.setTable("durations")
        self.durations_model.select()

        self.frequencies_model = QSqlTableModel()
        self.frequencies_model.setTable("frequencies")
        self.frequencies_model.select()

        self.intensities_model = QSqlTableModel()
        self.intensities_model.setTable("intensities")
        self.intensities_model.select()

        self.equipment_model = QSqlTableModel()
        self.equipment_model.setTable("equipment")
        self.equipment_model.select()

        self.exercises_model = ExercisesTableModel()
        self.exercises_model.setTable("exercises")
        self.exercises_model.select()

        self.filtered_exercises_model = ExercisesTableModel()
        self.filtered_exercises_model.setTable("exercises")
        self.filtered_exercises_model.select()


    def addExercise(self, ex_name, ex_description, t_id, 
                    f_id, i_id, d_id, e_id, ex_media):
        query = QSqlQuery()
        query.prepare("""INSERT OR IGNORE INTO exercises
                         (ex_name, ex_description, t_id, f_id, 
                          i_id, d_id, e_id, ex_media) 
                         VALUES (?, ?, ?, ?, ?, ?, ?, ?)""")

        query.addBindValue(QVariant(ex_name))
        query.addBindValue(QVariant(ex_description))
        query.addBindValue(QVariant(t_id))
        query.addBindValue(QVariant(f_id))
        query.addBindValue(QVariant(i_id))
        query.addBindValue(QVariant(d_id))
        query.addBindValue(QVariant(e_id))
        query.addBindValue(QVariant(ex_media))

        query.exec_()
        self.db.commit()
        self.exercises_model.select()


if __name__ == '__main__':
    Database()
