# builtin modules
import sys

# pyqt modules
from PyQt4.QtGui import (QApplication, QWizard, QStandardItem,  
                         QStandardItemModel)
from PyQt4.QtCore import (pyqtSignature, Qt, SIGNAL)
from PyQt4.QtMaemo5 import (QMaemo5ListPickSelector, QMaemo5ValueButton)
import sip

# third-party modules
import config as c

# program modules 
from ui_new_exercise_wizard import Ui_NewExerciseWizard
from database import Database

class NewExerciseWizard(QWizard, Ui_NewExerciseWizard):

    def __init__(self, parent=None, database=None):
        super(QWizard, self).__init__(parent)
        self.setAttribute(Qt.WA_DeleteOnClose, True)

        self.setupUi(self)
        self.db = database
        self.setupValueButtons()
        self.loadConfigOptions()
        self.reflowWidgets()

        self.connect(QApplication.desktop(), SIGNAL("resized(int)"), 
                     self.reflowWidgets)

        self.connect(self, SIGNAL("accepted()"), self.addExercise)

    def setupValueButtons(self):
        self.target_area_selector = QMaemo5ListPickSelector()
        self.target_area_selector.setModel(self.db.target_areas_model)
        self.target_area_selector.setModelColumn(1)
        self.target_area_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.target_area_value_button.setPickSelector(self.target_area_selector)

        self.duration_selector = QMaemo5ListPickSelector()
        self.duration_selector.setModel(self.db.durations_model)
        self.duration_selector.setModelColumn(1)
        self.duration_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.duration_value_button.setPickSelector(self.duration_selector)

        self.frequency_selector = QMaemo5ListPickSelector()
        self.frequency_selector.setModel(self.db.frequencies_model)
        self.frequency_selector.setModelColumn(1)
        self.frequency_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.frequency_value_button.setPickSelector(self.frequency_selector)

        self.intensity_selector = QMaemo5ListPickSelector()
        self.intensity_selector.setModel(self.db.intensities_model)
        self.intensity_selector.setModelColumn(1)
        self.intensity_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.intensity_value_button.setPickSelector(self.intensity_selector)

        self.equipment_selector = QMaemo5ListPickSelector()
        self.equipment_selector.setModel(self.db.equipment_model)
        self.equipment_selector.setModelColumn(1)
        self.equipment_value_button.setValueLayout(QMaemo5ValueButton.ValueBesideText)
        self.equipment_value_button.setPickSelector(self.equipment_selector)

    def addExercise(self):
        ex_name = self.name_line_edit.text()
        ex_description = self.description_text_edit.toPlainText() or 'NULL'

        index = self.target_area_selector.currentIndex()
        record = self.db.target_areas_model.record(index)
        t_id = record.value(0).toString() or 'NULL'
        
        index = self.duration_selector.currentIndex()
        record = self.db.durations_model.record(index)
        d_id = record.value(0).toString() or 'NULL'

        index = self.frequency_selector.currentIndex()
        record = self.db.frequencies_model.record(index)
        f_id = record.value(0).toString() or 'NULL'

        index = self.intensity_selector.currentIndex()
        record = self.db.intensities_model.record(index)
        i_id = record.value(0).toString() or 'NULL'

        index = self.equipment_selector.currentIndex()
        record = self.db.equipment_model.record()
        e_id = record.value(0).toString() or 'NULL'

        ex_media = self.file_name_line_edit.text() or 'NULL'
        
        self.db.addExercise(ex_name, ex_description, t_id, f_id, i_id, d_id,
                            e_id, ex_media)

    def loadConfigOptions(self):
        self.config = c.Config()
        self.setOrientation()

    def setOrientation(self):
        if self.config.interface['orientation'].lower() == 'auto':
            self.setAttribute(Qt.WA_Maemo5AutoOrientation)
        elif self.config.interface['orientation'].lower() == 'landscape':
            self.setAttribute(Qt.WA_Maemo5LandscapeOrientation)
        elif self.config.interface['orientation'].lower() == 'portrait':
            self.setAttribute(Qt.WA_Maemo5PortraitOrientation)

    def reflowWidgets(self):
        screen_geometry = QApplication.desktop().screenGeometry()
        #TODO: Figure out how to get buttons to layout horizontally portrait
        if screen_geometry.height() > screen_geometry.width():
            pass
