#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of maegirls.
#
# maegirls is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# maegirls is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with maegirls.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import os

import pickle
import time
import algo

version="0.1.1"

try:
    home=os.environ['HOME']
except:
    home="/home/user"

fn="%s/.maegirls" % (home, )

# Defaults for a girl
defaults={
    'cycle':	28,
    'day0':	algo.today(),
    }

# Default config
defaultcfg={
    'ver':	1,		# Configuration version
    'girls':	{		# List of configured girls
	'default':  defaults
	},
    'cur':	"default",	# Current girl
    }

def loadConfig():
    try:
	f=file(fn, "r")
	st=f.read()
	f.close()
	ret=pickle.loads(st)
    except:
	ret={}

#    print "load:", ret

    return(ret)

def sanitize_before_store(cfg0):
    cfg={
	'ver':	    cfg0['ver'],
	'cur':	    str(cfg0['cur']),
	'girls':    {}
	}

    if cfg0.has_key('girls'):
	for i in cfg0['girls']:
	    cfg['girls'][str(i)]=cfg0['girls'][i]

    return(cfg)

def storeConfig(cfg0):
    cfg0['ver']=1
    cfg=sanitize_before_store(cfg0)
#    print "store:", cfg
    st=pickle.dumps(cfg)
    f=file(fn, "w")
    f.write(st)
    f.close()

def storeGirl(name, dt):
    # Load old
    cfg=loadConfig()

    # Ensure
    if not cfg.has_key('girls'):
	cfg['girls']={}

    # Override
    cfg['girls'][name]={
	'cycle':    dt['cycle'],
	'day0':	    dt['day0'],
	}

    storeConfig(cfg)

def newGirl(name):
    global defaults

    storeGirl(name, defaults)

def loadGirls():
    cfg=loadConfig()
    try:
	ret=cfg['girls']
    except:
	ret={}

    return(ret)

def loadGirl(name):
    all=loadGirls()
    if all.has_key(name):
	ret=all[name]
    else:
	ret=defaults

    return(ret)

def girlExists(name):
    all=loadGirls()
    if all.has_key(name):
	ret=True
    else:
	ret=False
    return(ret)

def setCurrentGirl(name):
    cfg=loadConfig()
    cfg['cur']=name
    storeConfig(cfg)

def getCurrentGirl():
    cfg=loadConfig()
    try:
	ret=cfg['cur']
    except:
	ret='default'

    return(ret)

def removeGirl(name):
    cfg=loadConfig()
    if cfg['girls'].has_key(name):
	cfg['girls'].pop(name)
	storeConfig(cfg)

def init():
    cur=getCurrentGirl()
    if not girlExists(cur):
	storeConfig(defaultcfg)

# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

