#!/usr/bin/env python
# coding=UTF-8
# 
# Copyright (C) 2010 Stefanos Harhalakis
#
# This file is part of maegirls.
#
# maegirls is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# maegirls is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with maegirls.  If not, see <http://www.gnu.org/licenses/>.
#
# $Id: 0.py 2265 2010-02-21 19:16:26Z v13 $

__version__ = "$Id: 0.py 2265 2010-02-21 19:16:26Z v13 $"

import time

class Algo(object):
    def __init__(self):
	t=today()
	self.setReference(t, 28)

    # set day "day" as the reference day of starting period cycle
    # day is int(time.time()/86400)
    # cycle is the cycle width in days, starting from 0
    def setReference(self, day, cycle):
	self.refday=day
	self.cycle=cycle

    # Convert an arbitary day to a day in cycle
    def dayInCycle(self, day):
	d=(day-self.refday) % self.cycle
	if d<0:
	    d+=self.cycle

	return(d)

    def cycleLength(self):
	return(self.cycle)

    def currentDayInCycle(self):
	d=today()
	return(self.dayInCycle(d))

    # Return:
    # ret={
    #	'status':   ['ok', 'red']
    #	'day':	    day in status
    #	'len':	    length of status
    #	}
    #
    # e.g.  ret={'status':'red', 'day':0, 'len':5}
    #	    means that it is in red, in the first of 5
    def status(self, day):
	d=self.dayInCycle(day)

	ovbefore=14

	if d<5:
	    # Red
	    ret={
		'status':   'red',
		'day':	    d,
		'len':	    5,
		}
	elif d>=self.cycle-6:
	    ret={
		'status':   'blue',
		'day':	    6+d-self.cycle,
		'len':	    6,
		}
	elif d>self.cycle-ovbefore-4 and d<=self.cycle-ovbefore:
	    ret={
		'status':   'green',
		'day':	    d-self.cycle+ovbefore+3,
		'len':	    4,
		}
	elif d>self.cycle-16 and d<=self.cycle-ovbefore+1:
	    ret={
		'status':   'green',
		'day':	    2,
		'len':	    4,
		}
	else:
	    ret={
		'status':   'ok',
		'day':	    d,
		'len':	    self.cycle
		}

	return(ret)

def today():
    t=time.time() + time.timezone
    day=int(t/86400)

    return(day)


# vim: set ts=8 sts=4 sw=4 noet formatoptions=r ai nocindent:

