//#define DEBUG

#include <iostream>
#include <string>
#include <QtCore/QCoreApplication>
#include <QStringList>
#include <CMulticalendar.h>

#include <functions.h>

using namespace std;

QStringList args;
CMulticalendar *mcalendar = 0;


int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    args = a.arguments();

#ifdef DEBUG
    for(int i=0; i< args.size(); i++){
        cout << args.at(i).toLocal8Bit().constData() << endl;
    }
#endif

    mcalendar = CMulticalendar::MCInstance();

    QString operation;
    bool ok = true;

    //get operation first as it is always required
    if (!parse_cmd_arg(args, ARG_OPERATION_LONG, operation)){
        cout << "invalid '" << "--operation" << "' argument" << endl;

        cout << "try one of the following:" << endl;
        cout << "--operation import" << endl;
        cout << "--operation export" << endl;
        cout << "--operation list" << endl;
        cout << "--operation tasks-clear-done" << endl;
        cout << "--operation tasks-bump-today" << endl;

        return -1;
    }
    //cout << "operation is:" << operation.toLocal8Bit().constData() << endl;
    ok = do_operation(args, operation);

    if (!ok){
        cout << "Program failure" << endl;
        return -1;
    }

    //return a.exec();
    return 0;
}
