#ifndef FUNCTIONS_H
#define FUNCTIONS_H

#include <QString>

const QString ARG_OPERATION_LONG = "--operation";
const QString ARG_CAL_NAME = "--calendar";
const QString ARG_FILE_NAME = "--file";
const QString ARG_CLEAR = "--clear";
const QString ARG_VERIFY = "--verify";

//command-line argument strings
const QString ARG_OP_VAL_IMPORT = "import";
const QString ARG_OP_VAL_EXPORT = "export";
const QString ARG_OP_VAL_LIST = "list";
const QString ARG_OP_VAL_TASKS_CLEAR_DONE = "tasks-clear-done";

enum operationType {
    OPERATION_UNKNOWN = 0,
    OPERATION_IMPORT,
    OPERATION_EXPORT,
    OPERATION_LIST,
    OPERATION_TASKS_CLEAR_DONE
};

void print_cals(CMulticalendar&);
unsigned int parse_args(QStringList&);
unsigned int arg_to_code(QString);
bool parse_calendar(QStringList& args, QString& calendar);

bool parse_cmd_arg(const QStringList args, const QString arg);
bool parse_cmd_arg(const QStringList args, const QString arg, int& pos);
bool parse_cmd_arg(const QStringList args, const QString arg, QString& value);

bool do_operation(const QStringList args, const QString operation);
bool do_operation_list();
bool do_operation_import(const QStringList args);
bool do_operation_export(const QStringList args);
bool do_operation_tasks_clear_done(const QStringList args);

void usage_import();
void usage_export();
void usage_tasks_clear_done();

#endif // FUNCTIONS_H


