#include "dialogdeletefolder.h"
#include "ui_dialogdeletefolder.h"
#include <QMessageBox>
#include <QMaemo5InformationBox>
#include <QSqlQuery>
#include "db.h"

DialogDeleteFolder::DialogDeleteFolder(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DialogDeleteFolder)
{
    ui->setupUi(this);
}

DialogDeleteFolder::~DialogDeleteFolder()
{
    delete ui;
    this->folderId = 0;
    this->deleted = false;
}

void DialogDeleteFolder::setFolderId(int FolderId){
    this->folderId = FolderId;
}

void DialogDeleteFolder::on_buttonDelete_clicked()
{
    int answer = QMessageBox::question(this,"Delete","Are you sure you want to delete this folder and all its items?",
                                       QMessageBox::Yes,QMessageBox::No);
    if(answer == QMessageBox::Yes){
        QMaemo5InformationBox::information(this,"Not implemented yet! Sorry :(");
    }
}

void DialogDeleteFolder::on_buttonUnlink_clicked()
{
    int answer = QMessageBox::question(this,"Unlink","Do you want to remove this folder? All contents will move to Inbox.",
                                       QMessageBox::Yes,QMessageBox::No);
    if(answer == QMessageBox::Yes){
        unlinkFolder();
        this->deleted = true;
        this->hide();
    }

}

bool DialogDeleteFolder::getDeleted(){
    return this->deleted;
}

void DialogDeleteFolder::unlinkFolder(){

    if(this->folderId < 1) return;
    DB::unlinkFolder(this->folderId);

}
