#ifndef DB_H
#define DB_H
#include "folder.h"
#include <calendar-backend/CCalendar.h>

class DB
{
public:
    DB();

    static Folder* getFolder(int Id, int& pErrorCode);
    static int getCalendarIdForComponent(int ComponentId, int& pErrorCode);
    static bool checkFolderExists(QString FolderName, int ParentLevel);
    static bool createNewFolder(QString FolderName, int ParentLevel);
    static QString getFolderName(int FolderId);
    static CCalendar* getDefaultCalendar();
    static int getMinimumCalendarId();
    static void unlinkFolder(int FolderId);
};

#endif // DB_H
