#include "db.h"
#include <QSqlQuery>
#include <QVariant>
#include <calendar-backend/CalendarErrors.h>
#include <calendar-backend/CCalendar.h>
#include <calendar-backend/CMulticalendar.h>
#include <iostream>



using namespace std;

DB::DB()
{
}

Folder* DB::getFolder(int Id, int &pErrorCode) {
    Folder* f = new Folder();
    cout << "preparing query" << endl;
    QSqlQuery query;
    query.prepare("SELECT FolderId, Parent, Sequence, Summary FROM Folder WHERE FolderId = ?");
    query.addBindValue(QVariant(Id));
    cout << "query prepared" << endl;
    if(!query.exec()){
        cout << "query not ok" << endl;
        pErrorCode = CALENDAR_DATABASE_ERROR;

    } else {
        cout << "query ok" << endl;

        if(!query.first()){
            pErrorCode = CALENDAR_DATABASE_ERROR;
        }
        f->setId(Id);
        f->setParentId(query.value(1).toInt());

        f->setName(query.value(3).toString());
        //f->setDescription(query.value(3).toString());

        pErrorCode = CALENDAR_OPERATION_SUCCESSFUL;
    }


    return f;
}


int DB::getCalendarIdForComponent(int ComponentId, int &pErrorCode){
    int cal_id = 0;

    cout << "preparing query" << endl;
    QSqlQuery query;
    query.prepare("SELECT CalendarId FROM Components WHERE Id = ?");
    query.addBindValue(QVariant(ComponentId));
    cout << "query prepared" << endl;
    if(!query.exec()){
        cout << "query not ok" << endl;
        pErrorCode = CALENDAR_DATABASE_ERROR;

    } else {
        cout << "query ok" << endl;

        if(!query.first()){
            pErrorCode = CALENDAR_DATABASE_ERROR;
        } else {
        pErrorCode = CALENDAR_OPERATION_SUCCESSFUL;
        cal_id= query.value(0).toInt();
        }
    }

    return cal_id;
}

bool DB::checkFolderExists(QString FolderName, int ParentLevel){
    QSqlQuery query;
    query.prepare("SELECT FolderId FROM Folder WHERE Summary = ? and Parent = ?");

    query.addBindValue(FolderName);
    query.addBindValue(ParentLevel);
    query.exec();
    if (query.first()){
        return true;
    }

    return false;
}

bool DB::createNewFolder(QString FolderName, int ParentLevel){
    if(checkFolderExists(FolderName, ParentLevel)){
        return false;
    }

    QSqlQuery query;
    query.prepare("INSERT INTO Folder (Summary, Parent) VALUES (?,?)");
    query.addBindValue(FolderName);
    query.addBindValue(ParentLevel);
    return query.exec();

}

QString DB::getFolderName(int FolderId){
    QSqlQuery query;
    query.prepare("SELECT Summary FROM Folder WHERE FolderId=?");
    query.addBindValue(FolderId);
    query.exec();
    if(query.first()){
        return query.value(0).toString();
    } else {
        return "NOT A FOLDER";
    }
}

CCalendar* DB::getDefaultCalendar(){
    /*
      * wrapper around backend method that falls back if pointer is null
     */
    CCalendar* calendar = 0;
    calendar = CMulticalendar::MCInstance()->getDefaultCalendar();
    if(calendar){
        return calendar;    //return default
    } else {
        calendar = CMulticalendar::MCInstance()->getSynchronizedCalendar();
    }

    if(calendar){
        return calendar; //return synchronized
    } else {
        int calendar_id = 0;
        int error_code = 0;
        calendar_id = getMinimumCalendarId();
        calendar = CMulticalendar::MCInstance()->getCalendarById(calendar_id, error_code);
        return calendar; //return whatever we got
    }

}

int DB::getMinimumCalendarId(){
    int id = 0;

    QSqlQuery query;
    query.exec("SELECT MIN(CalendarId) FROM Calendars WHERE IsReadOnly=0");

    if(query.first()){
        id = query.value(0).toInt();
    }
    return id;
}

void DB::unlinkFolder(int Folder_Id){
    /*
     *  recursively go down the folder tree and clobber all links
     */
    if(Folder_Id < 1) {
        return;
    }

    cout << "!! UNLINKING FOLDER !!" << Folder_Id << endl;
    //remove links for content items
    QSqlQuery q1;
    q1.prepare("DELETE FROM FolderItem WHERE FolderId = ?");
    q1.addBindValue(Folder_Id);
    q1.exec();

    //get children
    QSqlQuery queryChildren;
    queryChildren.setForwardOnly(true);
    queryChildren.prepare("SELECT FolderId from Folder WHERE Parent=?");
    queryChildren.addBindValue(Folder_Id);
    bool ok = queryChildren.exec();
    if(ok){
        while (queryChildren.next()){
            //call ourself
           unlinkFolder(queryChildren.value(0).toInt());
        }
    }

    //delete folder itself
    QSqlQuery q2;
    q2.prepare("DELETE FROM Folder WHERE FolderId = ?");
    q2.addBindValue(Folder_Id);
    q2.exec();

    return;
}
