#include "taskviewitemdelegate.h"
#include "taskviewitemwidget.h"
#include <QPainter>
#include <QStyleOptionViewItem>
#include <QModelIndex>
#include <iostream>

using namespace std;


TaskViewItemDelegate::TaskViewItemDelegate(QObject *parent) :
    QStyledItemDelegate(parent), iw(new TaskViewItemWidget())
{
    instances++;
    cout << "Delegate Instances: " << instances << endl;
}

TaskViewItemDelegate::~TaskViewItemDelegate(){
    delete this->iw;
}

void TaskViewItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {

    QStyledItemDelegate::paint(painter, option, index); //paint parent
    painter->save();
    this->iw->resize(option.rect.size());
    painter->translate(option.rect.topLeft());
//    this->li->setSummary(index.sibling(index.row(),1).data().toString());
//    this->li->setSubtitle(index.sibling(index.row(),4).data().toString());
//    this->li->setIcon(index.sibling(index.row(),2).data().toString());
    this->iw->render(painter,QPoint(),QRegion(), QWidget::DrawChildren); //autofill off so we get default paint effects below
    painter->restore();

}
