#include "dialognoteedit.h"
#include "ui_dialognoteedit.h"

#include "dialogedittask.h"
#include "ui_dialogedittask.h"
#include <calendar-backend/CalendarErrors.h>
#include <calendar-backend/CMulticalendar.h>
#include <calendar-backend/CJournal.h>
#include <calendar-backend/CAlarm.h>
#include <calendar-backend/CCalendar.h>
#include <QtMaemo5/QMaemo5ValueButton>
#include <QtMaemo5/QMaemo5DatePickSelector>
#include <QtMaemo5/QMaemo5TimePickSelector>
#include "qmaemo5caldbpickselector.h"
#include "dialogfolderselect.h"
#include <QPixmap>
#include <QSqlQuery>

DialogNoteEdit::DialogNoteEdit(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DialogNoteEdit)
{
    ui->setupUi(this);
    ui->textEdit->setFocus();


    this->componentId = 0;
    this->componentCalendarId = 0;
    this->journal = 0;
    this->folderId = 0;
    this->deleted = false;

    deleteButton = new QPushButton("Delete", this);
    deleteButton->setText("Delete");
    deleteButton->setProperty("MODE","DELETE");

    ui->buttonBox->addButton("Save", QDialogButtonBox::AcceptRole);
    ui->buttonBox->addButton(this->deleteButton,QDialogButtonBox::DestructiveRole);


    this->calendarPickSelector = new QMaemo5CalDBPickSelector(this);
    ui->buttonCalendar->setPickSelector(this->calendarPickSelector);

    CCalendar* calendar = CMulticalendar::MCInstance()->getDefaultCalendar();
    if (!calendar){
        cout << "Error retrieving default Calendar" << endl;
    }
    QString calendarText = QString::fromLocal8Bit(calendar->getCalendarName().c_str());
    this->ui->buttonCalendar->setValueText(calendarText);
    this->calendarPickSelector->setCalendarId(calendar->getCalendarId());

}

DialogNoteEdit::~DialogNoteEdit()
{
    delete ui;
}

void DialogNoteEdit::setFolderId(int FolderId){
    this->folderId = FolderId;
    updateView();
}

int DialogNoteEdit::getCalendarId(){
    return this->calendarPickSelector->getCalendarId();
}

bool DialogNoteEdit::getDeleted(){
    return this->deleted;
}

void DialogNoteEdit::setComponentId(int ComponentId){
    this->componentId = ComponentId;
}

void DialogNoteEdit::setComponentCalendarId(int CalendarComponentId){
    this->componentCalendarId = CalendarComponentId;
}

void DialogNoteEdit::loadComponent(){
    //get the Component
    if(!getJournal()){
        ui->textEdit->setText("ERROR");
        return;
    }

    //ui->textEdit->setText(this->journal->getSummary().c_str());
    ui->textEdit->setText(QString::fromLocal8Bit(this->journal->getSummary().c_str()));
    //get the Folder
    updateView();
}

bool DialogNoteEdit::getJournal(){

    QString id= QString::number(this->componentId);

    int error_code = 0;
    int cal_id = CMulticalendar::MCInstance()->getCalendarIdForComponent
            (id.toLocal8Bit().constData(), error_code);

    if(error_code != CALENDAR_OPERATION_SUCCESSFUL || cal_id == 0){
        cout << "Error retrieving Calendar ID" << endl;
        return false;
    }

    CCalendar* calendar = CMulticalendar::MCInstance()->getCalendarById(cal_id, error_code);
    if (!calendar){
        cout << "Error retrieving Calendar" << endl;
        return false;
    }
    QString calendarText = QString::fromLocal8Bit(calendar->getCalendarName().c_str());
    this->ui->buttonCalendar->setValueText(calendarText);
    this->calendarPickSelector->setCalendarId(cal_id);

    CJournal* journal = calendar->getJournal(id.toLocal8Bit().constData(),error_code);
    if (!journal){
        cout << "Error retrieving Journal";
        return false;
    }

    this->journal = journal;

    //get folder id
    QSqlQuery q;
    q.prepare("SELECT FolderId FROM FolderItem WHERE Id=?");
    q.addBindValue(this->componentId);
    q.exec();
    if(q.first()){
        this->folderId = q.value(0).toInt();
    } else {
        this->folderId = -1;
    }

    return true;
}

void DialogNoteEdit::updateView(){
    //update the icon for calendar

    //update the icon and name for the folder id
    cout << "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++";
      cout << "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++";
cout << "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++";
cout << "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++";

    cout << "444444444444          " << "folder id is:" << this->folderId << endl;

    if(this->folderId  < 1){
        this->ui->buttonFolder->setIcon(QPixmap(
           "/usr/share/icons/hicolor/48x48/hildon/email_inbox.png"));
        this->ui->buttonFolder->setText("Inbox"); //TODO Really need to translate strings!
    } else {
        this->ui->buttonFolder->setIcon(QPixmap(
           "/usr/share/icons/hicolor/48x48/hildon/general_folder.png"));
        QSqlQuery q;
        q.prepare("SELECT Summary from Folder WHERE FolderId=?");
        q.addBindValue(this->folderId);
        q.exec();
        if(q.first()){
            this->ui->buttonFolder->setText(q.value(0).toString());
        } else {
            this->ui->buttonFolder->setText("ERROR");
        }

    }
}

bool DialogNoteEdit::saveJournal(){
    bool ok = true;
    if(!journal) {
        //must be a new one
        journal = new CJournal();
    }

    ok = this->journal->setSummary(this->ui->textEdit->toPlainText().toLocal8Bit().constData());
    cout << "calendar id BEFORE SAVE:" << this->calendarPickSelector->getCalendarId() << endl;
    this->journal->setCalendarId(this->calendarPickSelector->getCalendarId());


    int error_code;

    if(this->componentId > 0) {
        ok = CMulticalendar::MCInstance()->modifyJournal(this->journal,journal->getCalendarId(),error_code);
    } else {
        ok = CMulticalendar::MCInstance()->addJournal(this->journal,journal->getCalendarId(),error_code);

        cout << "333333333333333333        " << "new todo added with id: " << journal->getId() <<endl;
        int cid = (QString(journal->getId().c_str()).toInt());
        this->componentId = cid;
    }
        cout << "ERROR CODE IS:" << error_code << endl;

    // TODO this is not good form. really need to check for each error, but this is 0.1 version!

        //update the component id

    saveToFolder();

    return ok;
}

void DialogNoteEdit::saveToFolder(){

    QSqlQuery q1;
    q1.prepare("DELETE FROM FolderItem WHERE Id=?");
    q1.addBindValue(this->componentId);
q1.exec();
    //add always if not Inbox
    if(this->folderId == -1){
        return;
    }
    cout << "777777777777777777777777             " << this->folderId << endl;
    QSqlQuery q2;
    q2.prepare("INSERT INTO FolderItem VALUES(?,?)");
    q2.addBindValue(this->folderId);
    q2.addBindValue(this->componentId);
    q2.exec();
}

void DialogNoteEdit::on_buttonFolder_clicked()
{
    DialogFolderSelect d;
    d.exec();
    if(!d.getCanceled()){
        this->folderId = d.getFolderId();
        this->ui->buttonFolder->setText(d.getFolderName());
        updateView();
    }
}

void DialogNoteEdit::on_buttonBox_clicked(QAbstractButton *button){
    if(button->property("MODE") == "DELETE"){
        this->deleted = true;
        this->hide();
    }
}
