#include "dialogedittask.h"
#include "ui_dialogedittask.h"
#include <calendar-backend/CalendarErrors.h>
#include <calendar-backend/CMulticalendar.h>
#include <calendar-backend/CTodo.h>
#include <calendar-backend/CAlarm.h>
#include <calendar-backend/CCalendar.h>
#include <QtMaemo5/QMaemo5ValueButton>
#include <QtMaemo5/QMaemo5DatePickSelector>
#include <QtMaemo5/QMaemo5TimePickSelector>
#include "qmaemo5caldbpickselector.h"
#include "dialogfolderselect.h"
#include <QPixmap>
#include <QSqlQuery>

DialogEditTask::DialogEditTask(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DialogEditTask)
{

    this->componentId = 0;
    this->componentCalendarId = 0;
    this->todo = 0;
    this->folderId = 0;
    this->deleted = false;

    ui->setupUi(this);

    deleteButton = new QPushButton("Delete", this);
    deleteButton->setText("Delete");
    deleteButton->setProperty("MODE","DELETE");

    ui->buttonBox->addButton("Save", QDialogButtonBox::AcceptRole);
    ui->buttonBox->addButton(this->deleteButton,QDialogButtonBox::DestructiveRole);
    //ui->buttonBox->addButton("Delete", QDialogButtonBox::DestructiveRole);

    //TODO - ValueBesideText is pushing it off to the right. so weird.
    //ui->buttonDueDate->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    this->dueDatePickSelector = new QMaemo5DatePickSelector(this);
    ui->buttonDueDate->setPickSelector(dueDatePickSelector);

    //this->calendarPickSelector = new QMaemo5CalendarPickSelector(this);

    this->calendarPickSelector = new QMaemo5CalDBPickSelector(this);
    ui->buttonCalendar->setPickSelector(this->calendarPickSelector);

    CCalendar* calendar = CMulticalendar::MCInstance()->getDefaultCalendar();
    if (!calendar){
        cout << "Error retrieving default Calendar" << endl;
    }
    QString calendarText = QString::fromLocal8Bit(calendar->getCalendarName().c_str());
    this->ui->buttonCalendar->setValueText(calendarText);
    this->calendarPickSelector->setCalendarId(calendar->getCalendarId());


    //ui->buttonCalendar->setValueText("TESTING");

    this->alarmDatePickSelector = new QMaemo5DatePickSelector(this);
    ui->buttonAlarmDate->setPickSelector(alarmDatePickSelector);

    ui->buttonAlarmTime->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    this->alarmTimePickSelector = new QMaemo5TimePickSelector(this);
    ui->buttonAlarmTime->setPickSelector(alarmTimePickSelector);


    this->ui->editSummary->setFocus();
}

DialogEditTask::~DialogEditTask()
{
    delete ui;
}

bool DialogEditTask::getDeleted(){
    return this->deleted;
}

void DialogEditTask::setComponentId(int ComponentId){
    this->componentId = ComponentId;
}

void DialogEditTask::setComponentCalendarId(int CalendarComponentId){
    this->componentCalendarId = CalendarComponentId;
}

void DialogEditTask::loadComponent(){
    //get the Component
    if(!getTodo()){
        ui->editSummary->setText("ERROR");
        return;
    }

    ui->editSummary->setText(QString::fromLocal8Bit(todo->getSummary().c_str()));
    ui->checkDone->setChecked(QVariant(todo->getStatus()).toBool());
    ui->textDescription->setText(QString::fromLocal8Bit(todo->getDescription().c_str()));

    QDateTime dueDateTime;
    dueDateTime.setTime_t(todo->getDue());
    this->dueDatePickSelector->setCurrentDate(dueDateTime.date());

    int priority = todo->getPriority();
    if(priority < 1 || priority > 5) {
        priority = 5;
    }
    ui->comboPriority->setCurrentIndex(priority-1);

    CAlarm* alarm = todo->getAlarm();
    if(!alarm){
        toggleAlarmButtons(true);
    } else {
        QDateTime alarmDateTime;
        alarmDateTime.setTime_t(alarm->getTrigger());
        ui->checkAlarm->setChecked(true);
        this->alarmDatePickSelector->setCurrentDate(alarmDateTime.date());
        this->alarmTimePickSelector->setCurrentTime(alarmDateTime.time());
        toggleAlarmButtons(false);
    }
    //if(todo->getAlarm();)

    //get the Folder
    updateView();
}

bool DialogEditTask::getTodo(){
    QString id= QString::number(this->componentId);

    int error_code = 0;
    int cal_id = CMulticalendar::MCInstance()->getCalendarIdForComponent
            (id.toLocal8Bit().constData(), error_code);

    if(error_code != CALENDAR_OPERATION_SUCCESSFUL || cal_id == 0){
        cout << "Error retrieving Calendar ID" << endl;
        return false;
    }

    CCalendar* calendar = CMulticalendar::MCInstance()->getCalendarById(cal_id, error_code);
    if (!calendar){
        cout << "Error retrieving Calendar" << endl;
        return false;
    }
    QString calendarText = QString::fromLocal8Bit(calendar->getCalendarName().c_str());
    this->ui->buttonCalendar->setValueText(calendarText);
    this->calendarPickSelector->setCalendarId(cal_id);

    CTodo* todo = calendar->getTodo(id.toLocal8Bit().constData(),error_code);
    if (!todo){
        cout << "Error retrieving Task";
        return false;
    }

    this->todo = todo;

    //get folder id
    QSqlQuery q;
    q.prepare("SELECT FolderId FROM FolderItem WHERE Id=?");
    q.addBindValue(this->componentId);
    q.exec();
    if(q.first()){
        this->folderId = q.value(0).toInt();
    } else {
        this->folderId = -1;
    }

    return true;
}

void DialogEditTask::toggleAlarmButtons(bool setHidden){
    this->ui->buttonAlarmDate->setHidden(setHidden);
    this->ui->buttonAlarmTime->setHidden(setHidden);
}

void DialogEditTask::on_checkAlarm_stateChanged(int state)
{
    if(state == Qt::Checked){
        toggleAlarmButtons(false);
    } else {
        toggleAlarmButtons(true);
    }
}

void DialogEditTask::on_buttonBox_clicked(QAbstractButton *button)
{
    if(button->property("MODE") == "DELETE"){
        this->deleted = true;
        this->hide();
    }

}

int DialogEditTask::getComponentId(){
    return this->componentId;
}

QString DialogEditTask::getSummary(){
    return this->ui->editSummary->text();
}

int DialogEditTask::getStatus(){
    return this->ui->checkDone->checkState() == Qt::Checked ? 1 : 0;
}

QDate DialogEditTask::getDueDate(){
    return dueDatePickSelector->currentDate();
}

int DialogEditTask::getCalendarId(){
    return this->calendarPickSelector->getCalendarId();
}

int DialogEditTask::getPriority(){
    return this->ui->comboPriority->currentIndex() + 1;
}

QString DialogEditTask::getDescription(){
    return this->ui->textDescription->toPlainText();
}

bool DialogEditTask::getAlarmIsSet(){
    return this->ui->checkAlarm;
}

QDate DialogEditTask::getAlarmDate(){
    return this->alarmDatePickSelector->currentDate();
}

QTime DialogEditTask::getAlarmTime(){
    return this->alarmTimePickSelector->currentTime();
}

bool DialogEditTask::saveTodo(){
    bool ok = true;
    if(!todo) {
        //must be a new one
        todo = new CTodo();
    }

    ok = this->todo->setSummary(this->ui->editSummary->text().toLocal8Bit().constData());
    ok = this->todo->setStatus(this->ui->checkDone->checkState() == Qt::Checked ? 1 : 0);
    QDateTime dueDate;
    dueDate.setDate(this->dueDatePickSelector->currentDate());
    ok = this->todo->setDue(dueDate.toUTC().toTime_t());
    cout << "calendar id BEFORE SAVE:" << this->calendarPickSelector->getCalendarId() << endl;
    this->todo->setCalendarId(this->calendarPickSelector->getCalendarId());
    this->todo->setPriority(this->ui->comboPriority->currentIndex() + 1);
    this->todo->setDescription(this->ui->textDescription->toPlainText().toLocal8Bit().constData());
    //TODO - need to add and remove alarm if necessary

    int error_code;

    if(this->componentId > 0) {
        ok = CMulticalendar::MCInstance()->modifyTodo(this->todo,todo->getCalendarId(), error_code);
    } else {
        ok = CMulticalendar::MCInstance()->addTodo(todo,todo->getCalendarId(), error_code);

        cout << "333333333333333333        " << "new todo added with id: " << todo->getId() <<endl;
        int cid = (QString(todo->getId().c_str()).toInt());
        this->componentId = cid;
    }
        cout << "ERROR CODE IS:" << error_code << endl;

    // TODO this is not good form. really need to check for each error, but this is 0.1 version!

        //update the component id

    saveToFolder();

    return ok;
}

void DialogEditTask::on_buttonFolder_clicked()
{
    DialogFolderSelect d;
    d.exec();
    if(!d.getCanceled()){
        this->folderId = d.getFolderId();
        this->ui->buttonFolder->setText(d.getFolderName());
        updateView();
    }
}

void DialogEditTask::setFolderId(int FolderId){
    cout << "0000000000000000000000000000000000    FOLDER ID:" << FolderId << endl;
    this->folderId = FolderId;
    updateView();
}

void DialogEditTask::updateView(){
    //update the icon for calendar

    //update the icon and name for the folder id
    if(this->folderId == -1){
        this->ui->buttonFolder->setIcon(QPixmap(
           "/usr/share/icons/hicolor/48x48/hildon/email_inbox.png"));
        this->ui->buttonFolder->setText("Inbox"); //TODO Really need to translate strings!
    } else {
        this->ui->buttonFolder->setIcon(QPixmap(
           "/usr/share/icons/hicolor/48x48/hildon/general_folder.png"));
        QSqlQuery q;
        q.prepare("SELECT Summary from Folder WHERE FolderId=?");
        q.addBindValue(this->folderId);
        q.exec();
        if(q.first()){
            this->ui->buttonFolder->setText(q.value(0).toString());
        } else {
            this->ui->buttonFolder->setText("ERROR");
        }

    }
}

void DialogEditTask::saveToFolder(){

    cout << "4444444444444444444444           " << "saving to folder: " << this->folderId;
    //TODO - really need to move
    //all DB access to central facade the way the calendar-backend API does it

    //delete first
    QSqlQuery q1;
    q1.prepare("DELETE FROM FolderItem WHERE Id=?");
    q1.addBindValue(this->componentId);
    cout << "4444444444444444444444 " << " deleting " <<  q1.exec() << endl;

    //add always if not Inbox
    if(this->folderId == -1){
        return;
    }

    QSqlQuery q2;
    q2.prepare("INSERT INTO FolderItem VALUES(?,?)");
    q2.addBindValue(this->folderId);
    q2.addBindValue(this->componentId);
    cout << "4444444444444444444444 " << " inserting " <<  q2.exec() << endl;


}
