#include "formhome.h"
#include "ui_formhome.h"
#include "database.h"
#include <QDateTime>
#include <QStringBuilder>
#include <QString>
#include <QMaemo5InformationBox>
#include <QInputDialog>
#include <QLineEdit>
#include <db.h>
#include <iostream>
#include "taskeditor.h"
using namespace std;

FormHome::FormHome(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::FormHome)
{
    nav = 0;

    ui->setupUi(this);
    group_model = new QSqlQueryModel();
    group_model->setQuery(DML_GROUP_LIST);
    ui->listViewGroups->setModel(group_model);
    ui->listViewGroups->setModelColumn(1);

}

FormHome::~FormHome()
{
    delete ui;
}

void FormHome::on_listWidgetHome_activated(const QModelIndex &index)
{
    switch(index.row()){
    case 0:
        //INBOX
        launchInbox();
        break;
    case 1:
        //LATE
        launchLate();
        break;
    case 2:
        //TODAY
        launchToday();
        break;
    case 3:
        //TOMORROW
        launchTomorrow();
        break;
    case 4: //TASKS
        launchTasks();
        break;
    case 5:
        launchNotes();
        break;
    default:
        return;
    }
}

void FormHome::launchInbox(){

    if(!nav){
        nav = new FormTaskListNavigator(this);
    }

    nav->setSQLWhereClause("(Type = '2' OR Type ='3') AND id NOT IN (SELECT Id FROM FolderItem)");
    nav->updateQuery();
    nav->setAttribute(Qt::WA_Maemo5StackedWindow);
    nav->setWindowFlags(nav->windowFlags() | Qt::Window);
    nav->setWindowTitle("Inbox");
    nav->hideFolderButton(true);
    nav->hideNoteButton(false);
    nav->show();
}

void FormHome::launchTasks(){
    if(!nav){
        nav = new FormTaskListNavigator(this);
    }

    nav->setSQLWhereClause("(Type = '2')");
    nav->updateQuery();
    nav->setAttribute(Qt::WA_Maemo5StackedWindow);
    nav->setWindowFlags(nav->windowFlags() | Qt::Window);
    nav->setWindowTitle("Tasks");
    nav->hideFolderButton(true);
    nav->hideNoteButton(true);
    nav->show();
}

void FormHome::launchLate(){

    QDateTime now;
    int i = now.currentDateTime().toUTC().toTime_t();

    if(!nav){
        nav = new FormTaskListNavigator(this);
    }
    cout << "NOW is: " << i << endl;
    int j = i - 43200;
    QString clause = "Type = '2' AND DateStart < " % QString::number(j) % " AND Status=0";
    nav->setSQLWhereClause(clause);
    nav->updateQuery();
    nav->setAttribute(Qt::WA_Maemo5StackedWindow);
    nav->setWindowFlags(nav->windowFlags() | Qt::Window);
    nav->setWindowTitle("Late");
    nav->hideFolderButton(true);
    nav->hideNoteButton(true);
    nav->show();

}

void FormHome::launchToday(){

    if(!nav){
        nav = new FormTaskListNavigator(this);
    }

    QDateTime now;
    //86400 is one day, 43200
    int i = now.currentDateTime().toUTC().toTime_t();
    cout << "NOW is: " << i << endl;
    int j = i - 43200;
    int k = i + 43200;

    QString clause = "Type = '2' AND DateStart BETWEEN " % QString::number(j) % " AND " % QString::number(k) % " AND Status=0";
    nav->setSQLWhereClause(clause);
    nav->updateQuery();
    nav->setAttribute(Qt::WA_Maemo5StackedWindow);
    nav->setWindowFlags(nav->windowFlags() | Qt::Window);
    nav->setWindowTitle("Today");
    nav->hideFolderButton(true);
    nav->hideNoteButton(true);
    cout << "HOLA" << endl;
    nav->show();


}

void FormHome::launchTomorrow(){
    QDateTime now;
    int i = now.currentDateTime().toUTC().toTime_t();

    if(!nav){
        nav = new FormTaskListNavigator(this);
    }
    cout << "NOW is: " << i << endl;
    int j = i + 43200;
    QString clause = "Type = '2' AND DateStart > " % QString::number(j) % " AND Status=0";
    nav->setSQLWhereClause(clause);
    nav->updateQuery();
    nav->setAttribute(Qt::WA_Maemo5StackedWindow);
    nav->setWindowFlags(nav->windowFlags() | Qt::Window);
    nav->setWindowTitle("Tomorrow");
    nav->hideFolderButton(true);
    nav->hideNoteButton(true);
    nav->show();
}

void FormHome::launchNotes(){
    if(!nav){
        nav = new FormTaskListNavigator(this);
    }

    nav->setSQLWhereClause("(Type = '3')");
    nav->updateQuery();
    nav->setAttribute(Qt::WA_Maemo5StackedWindow);
    nav->setWindowFlags(nav->windowFlags() | Qt::Window);
    nav->setWindowTitle("Notes");
    nav->hideFolderButton(true);
    nav->hideNoteButton(false);
    nav->hideTaskButton(true);
    nav->show();
}

void FormHome::on_listViewGroups_activated(const QModelIndex &index)
{
    int folderId = index.sibling(index.row(),0).data().toInt();


    if(!nav){
        nav = new FormTaskListNavigator(this);
    }

    nav->setFolderId(folderId);

    QString f = QString::number(folderId);
    QString clause = "(Type = '0' AND Id IN (SELECT FolderId FROM Folder WHERE Parent=" % f % "))";
    clause = clause % " OR ((Type = '2' OR Type='3') AND Id IN (SELECT id FROM FolderItem WHERE FolderId=" % f % "))";

    nav->setSQLWhereClause(clause);
    nav->updateQuery();
    nav->setAttribute(Qt::WA_Maemo5StackedWindow);
    nav->setWindowFlags(nav->windowFlags() | Qt::Window);
    //nav->setWindowTitle("Folder Name?");
    nav->hideTaskButton(false);
    nav->hideFolderButton(false);
    nav->hideNoteButton(false);
    nav->show();
    group_model->setQuery(DML_GROUP_LIST); //process any deletes down the chain.
}

void FormHome::on_pushButton_2_clicked()
{

    ///UGLY!

    bool ok = true;
    while (ok) //user is continuing to try to add
    {
        QString text = QInputDialog::getText(this,"Add Folder", "Folder Name",QLineEdit::Normal,"New Folder",&ok);
        if(ok && !text.isEmpty()){
            ok = DB::checkFolderExists(text,0);
            if(ok){
                QMaemo5InformationBox::information(this,"Folder already exists! Try again.");
            } else {
                ok = DB::createNewFolder(text, 0);
                if(!ok){
                    QMaemo5InformationBox::information(this,"Failed to create folder!");
                } else {
                    ok = false;
                    group_model->setQuery(DML_GROUP_LIST);
                }
            }
        }
    }
}

void FormHome::on_pushButton_clicked()
{
    TaskEditor te;
    te.addTask();
}
