#include "formtodolist.h"
#include "ui_formtodolist.h"
#include "tasklistmodel.h"
#include "taskviewitemdelegate.h"
#include "taskfolderitemdelegate.h"
#include "calendarcomponentlistdelegate.h"
#include <QStringBuilder>
#include "formtasklistnavigator.h"
#include "taskeditor.h"
#include "noteeditor.h"

#include <iostream>

using namespace std;

FormTodoList::FormTodoList(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::FormTodoList)
{
    ui->setupUi(this);
    this->nav = 0;

    this->SQLSelectClause = "\
            SELECT * FROM ( \
                SELECT status, id, '2' as type,summary,'' as delegate, DateStart, 0 as FolderId from components where componenttype=2 \
            UNION SELECT '2', id, '3' as type , summary,'' as delegate, DateStart, 0 as FolderId from components where componenttype=3 \
            UNION SELECT '2', FolderId as id, '0' as type, summary,'' as delegate, 0 as DateStart, FolderId FROM Folder \
            ) AS DATA";

    // SQLWhereClause // NO Filter by default

            //TODO ORDERING is NOT WORKING for some reason
    this->SQLOrderClause = "type, id";  //can be overridden externally via setters

    //model = new QSqlQueryModel(this);
    model = new TaskListModel(ui->treeView);
    updateQuery();

//    // QUERY
//    model->setQuery( "\
//                     SELECT status, id, '2' as type,summary,'' as delegate from components where componenttype=2 \
//            UNION SELECT '2', id, '3' as type , summary,'' as delegate from components where componenttype=3 \
//            UNION SELECT '2', FolderId, '0' as type, summary,'' as delegate FROM Folder \
//                     ");

                     //ORDER BY type, id \

                     /*
                 model->setQuery( "\
                                                       SELECT status, id, componenttype,summary,status from components where componenttype=2 \
                                                       ");
                                                       */
                     //model->setQuery("SELECT id,status,summary from components where componenttype=2");
                     cout << "setting up UI for task list" << endl;

    ui->treeView->setModel(model);

    //ui->treeView->setColumnHidden(0,true);
    ui->treeView->setColumnHidden(1,true);
    ui->treeView->setColumnHidden(2,true);
    ui->treeView->setColumnHidden(3,true);
    ui->treeView->setColumnHidden(4,true);
    ui->treeView->setColumnHidden(5,true);
ui->treeView->setColumnHidden(6,true);

cout << "row count " << model->rowCount() << endl;
//    for (int r=0; r< model->rowCount(); r++){
//        //which type is it?
//        //cout << "row: " << r << endl;
//        //cout << model->index(r,2).data().toInt() << endl;
//        int id = model->index(r,1).data().toInt();
//        int type = model->index(r,2).data().toInt();
//        cout << "ID is:" << id << endl;

//        CalendarComponentListDelegate* delegate = new CalendarComponentListDelegate(this);
//        delegate->setComponent(id, type);
//        ui->treeView->setItemDelegateForRow(r,delegate);
//    }
    DrawDelegates();

    //ui->treeView->setItemDelegateForColumn(3, new TaskViewItemDelegate());
    //ui->treeView->itemAt(0,0)->setFirstColumnSpanned(true);
    //ui->treeView->setItemDelegateForRow(0, new TaskFolderItemDelegate());

    connect(model,SIGNAL(dataChanged(QModelIndex,QModelIndex)),SLOT(dataChanged(QModelIndex,QModelIndex)));
    //connect(model, SIGNAL(dataChanged(QModelIndex,QModelIndex)),ui->treeView,SLOT(dataChanged(QModelIndex,QModelIndex)));

}

FormTodoList::~FormTodoList()
{
    delete ui;
}

void FormTodoList::dataChanged(const QModelIndex & topLeft, const QModelIndex & bottomRight){
    updateQuery();
}

void FormTodoList::DrawDelegates(){
    for (int r=0; r< model->rowCount(); r++){
        int id = model->index(r,1).data().toInt();
        int type = model->index(r,2).data().toInt();
        CalendarComponentListDelegate* delegate = new CalendarComponentListDelegate(this);
        delegate->setComponent(id, type);
        ui->treeView->setItemDelegateForRow(r,delegate);
    }
}

void FormTodoList::setSQLWhereClause(QString WhereClause){
    this->SQLWhereClause = WhereClause;
}

void FormTodoList::updateQuery(){
    //generate the query and then update the model, too.
    cout << "QUERY IS:" << getQuery().toLocal8Bit().constData() << endl;
    model->clear();
    this->model->setQuery(getQuery());
    DrawDelegates();
}

QString FormTodoList::getQuery(){
    //generate the query if it's been changed from defaults
    QString sql = this->SQLSelectClause;

    if(this->SQLWhereClause.length()>0){
        sql = sql % " WHERE " % this->SQLWhereClause;
    }

    if(this->SQLOrderClause.length()>0){
        sql = sql % " ORDER BY " % this->SQLOrderClause;
    }

    return sql;
}



void FormTodoList::on_treeView_activated(const QModelIndex &index)
{
    int type = index.sibling(index.row(),2).data().toInt();
    int id = index.sibling(index.row(),1).data().toInt();

    switch (type){
    case 2:
        launchTaskEditor(id);

        break;
    case 3:{
        NoteEditor e;
        e.editJournal(id);

        break;
    }
    case 0:
        drillDown(id);
        break;

    }
}

void FormTodoList::launchTaskEditor(int ComponentId){
    TaskEditor e;
    e.editTask(ComponentId);
    //model->clear();
    updateQuery();
}

void FormTodoList::drillDown(int FolderId){

    if(!nav){
        nav = new FormTaskListNavigator(this);
    }

    cout << "777777777777777777777          " << FolderId <<endl;
    nav->setFolderId(FolderId);
    QString f = QString::number(FolderId);
    QString clause = "(Type = '0' AND Id IN (SELECT FolderId FROM Folder WHERE Parent=" % f % "))";
    clause = clause % " OR ((Type = '2' OR Type='3') AND Id IN (SELECT id FROM FolderItem WHERE FolderId=" % f % "))";

    nav->setSQLWhereClause(clause);
    nav->updateQuery();
    nav->setAttribute(Qt::WA_Maemo5StackedWindow);
    nav->setWindowFlags(nav->windowFlags() | Qt::Window);
    //nav->setWindowTitle("Folder Name?");
    nav->show();



}
