#ifndef DIALOGEDITTASK_H
#define DIALOGEDITTASK_H

#include <QDialog>

class QMaemo5ValueButton;
class QMaemo5DatePickSelector;
class QMaemo5TimePickSelector;
class QMaemo5CalendarPickSelector;
class CTodo;
class QMaemo5CalDBPickSelector;
class QAbstractButton;
class QDate;
class QTime;

namespace Ui {
class DialogEditTask;
}

class DialogEditTask : public QDialog
{
    Q_OBJECT
    
public:
    explicit DialogEditTask(QWidget *parent = 0);
    ~DialogEditTask();

    void setComponentId(int ComponentId);
    void setComponentCalendarId(int CalendarComponentId);
    void loadComponent();
    bool getDeleted();
    bool saveTodo();

    void setFolderId(int FolderId);
    QString getSummary();
    int getStatus();
    QDate getDueDate();
    int getComponentId();
    int getCalendarId();
    int getPriority();
    QString getDescription();
    bool getAlarmIsSet();
    QDate getAlarmDate();
    QTime getAlarmTime();
    
private slots:
    void on_checkAlarm_stateChanged(int arg1);

    void on_buttonBox_clicked(QAbstractButton *button);

    void on_buttonFolder_clicked();

private:
    Ui::DialogEditTask *ui;

    QMaemo5DatePickSelector* dueDatePickSelector;
    QMaemo5DatePickSelector* alarmDatePickSelector;
    QMaemo5TimePickSelector* alarmTimePickSelector;
    QMaemo5CalDBPickSelector* calendarPickSelector;

    QPushButton* deleteButton;

    int componentId;
    int componentCalendarId;

    int folderId;

    CTodo* todo;

    bool getTodo();
    bool getFolder();
    void toggleAlarmButtons(bool setHidden);

    bool deleted;
    void updateView();
    void saveToFolder(); //BAD! need to check results better

};

#endif // DIALOGEDITTASK_H
