#include "db.h"
#include <QSqlQuery>
#include <QVariant>
#include <calendar-backend/CalendarErrors.h>

#include <iostream>



using namespace std;

DB::DB()
{
}

Folder* DB::getFolder(int Id, int &pErrorCode) {
    Folder* f = new Folder();
    cout << "preparing query" << endl;
    QSqlQuery query;
    query.prepare("SELECT FolderId, Parent, Sequence, Summary FROM Folder WHERE FolderId = ?");
    query.addBindValue(QVariant(Id));
    cout << "query prepared" << endl;
    if(!query.exec()){
        cout << "query not ok" << endl;
        pErrorCode = CALENDAR_DATABASE_ERROR;

    } else {
        cout << "query ok" << endl;

        if(!query.first()){
            pErrorCode = CALENDAR_DATABASE_ERROR;
        }
        f->setId(Id);
        f->setParentId(query.value(1).toInt());

        f->setName(query.value(3).toString());
        //f->setDescription(query.value(3).toString());

        pErrorCode = CALENDAR_OPERATION_SUCCESSFUL;
    }


    return f;
}


int DB::getCalendarIdForComponent(int ComponentId, int &pErrorCode){
    int cal_id = 0;

    cout << "preparing query" << endl;
    QSqlQuery query;
    query.prepare("SELECT CalendarId FROM Components WHERE Id = ?");
    query.addBindValue(QVariant(ComponentId));
    cout << "query prepared" << endl;
    if(!query.exec()){
        cout << "query not ok" << endl;
        pErrorCode = CALENDAR_DATABASE_ERROR;

    } else {
        cout << "query ok" << endl;

        if(!query.first()){
            pErrorCode = CALENDAR_DATABASE_ERROR;
        } else {
        pErrorCode = CALENDAR_OPERATION_SUCCESSFUL;
        cal_id= query.value(0).toInt();
        }
    }

    return cal_id;
}

bool DB::checkFolderExists(QString FolderName, int ParentLevel){
    QSqlQuery query;
    query.prepare("SELECT FolderId FROM Folder WHERE Summary = ? and Parent = ?");

    query.addBindValue(FolderName);
    query.addBindValue(ParentLevel);
    query.exec();
    if (query.first()){
        return true;
    }

    return false;
}

bool DB::createNewFolder(QString FolderName, int ParentLevel){
    if(checkFolderExists(FolderName, ParentLevel)){
        return false;
    }

    QSqlQuery query;
    query.prepare("INSERT INTO Folder (Summary, Parent) VALUES (?,?)");
    query.addBindValue(FolderName);
    query.addBindValue(ParentLevel);
    return query.exec();

}

QString DB::getFolderName(int FolderId){
    QSqlQuery query;
    query.prepare("SELECT Summary FROM Folder WHERE FolderId=?");
    query.addBindValue(FolderId);
    query.exec();
    if(query.first()){
        return query.value(0).toString();
    } else {
        return "epic fail";
    }
}
