#include "eventview.h"
#include "ui_eventview.h"
#include <calendar-backend/CalendarErrors.h>
#include <calendar-backend/CMulticalendar.h>
#include <calendar-backend/CCalendar.h>
#include <calendar-backend/CEvent.h>
#include "main.cpp"
#include <QDateTime>
#include <calendar-backend/CRecurrence.h>
#include <calendar-backend/CRecurrenceRule.h>
#include "dialogeditrepeat.h"
#include <iostream>
#include "dialogeditrange.h"
#include "dialogeditrule.h"

using namespace std;

EventView::EventView(QWidget *parent) :
    QScrollArea(parent),
    ui(new Ui::EventView)
{
    ui->setupUi(this);

    m_calendarid = 0;
    m_eventid = 0;
}

EventView::~EventView()
{
    delete ui;
    delete m_event;
}

void EventView::setCalendarId(int calendarid){
    m_calendarid = calendarid;
}

void EventView::setEventId(int eventid){
    m_eventid = eventid;
}

void EventView::loadEventInfo(){
    //loads the CEvent for the form
    cout << "ENTERING: loadEventInfo()" << endl;
    if (getEvent(m_calendarid, m_eventid)){
        ui->labelSummary->setText(QString(m_event->getSummary().c_str()));
        ui->labelDescription->setText(QString(m_event->getDescription().c_str()));

        QDateTime qdtStart;
        qdtStart.setTime_t(m_event->getDateStart());
        ui->labelDate->setText(qdtStart.date().toString());
        ui->labelTime->setText(qdtStart.time().toString());

        ui->labelRepeat->setText(resolveRType(this->m_event->getRecurrence()->getRtype()));
        ui->labelRule->setText(this->m_firstrule->getRrule().c_str());

    } else {
        ui->labelSummary->text() = "ERROR";

    }
}

bool EventView::getEvent(int calendarid, int eventid){
    cout << "ENTERING: getEvent(" << calendarid << "," << eventid << ")" << endl;
    int e = 0;
    CCalendar *c = mcalendar->getCalendarById(calendarid, e);
    if (e != CALENDAR_OPERATION_SUCCESSFUL){
        cout << "Failed to get the calendar. Error code: " << e << endl;
        return false;
    }
    e = 0;

    m_event = c->getEvent(QString::number(eventid).toStdString(),e);
    if (e != CALENDAR_OPERATION_SUCCESSFUL){
        cout << "Failed to get the event. Error code: " << e << endl;
        return false;
    }

    //load the first recurrence rule. we only support events with one rule for now.
    vector <CRecurrenceRule *> rules = this->m_event->retrieveRecurreceRuleObject();
    //if(rules){
        if(rules.size()==1){
            this->m_firstrule = rules.at(0);
            cout << "GOT FIRST RULE! " << this->m_firstrule->toString().c_str() << endl;
        } else if (rules.size() > 1){
            ui->pushButton->setEnabled(false);
            ui->pushButton->setText("Very complex rule. Cannot Edit");
        } else {
            ui->pushButton->setEnabled(false);
            ui->pushButton->setText("Error occurrend. Cannot Edit");
        }
    //}


    return true;
}

void EventView::debugRecurrence(){
    CRecurrence *r = m_event->getRecurrence();

    if(!r) {
        cout << "No Recurrence Pointer" << endl;
        cout << "btw, the rtype is:" << m_event->getRtype() << endl;
        return;
    }
    cout << "Rule type:" << r->getRtype() << endl;

    vector <CRecurrenceRule *> rules = r->getRecurrenceRule();
    cout << "Rules size:" << rules.size() << endl;
    for (unsigned int i=0; i<rules.size(); i++){
        CRecurrenceRule *rule = rules.at(i);
        cout << "Parsing rule:";
        cout << rule->rruleParser(rule->getRrule());
        cout << "Rule is:";
        cout << rule->toString() << endl;

        cout << "Rule explicit:" << rule->getRrule().c_str() << endl;

        cout << "is complex: ";
        if(rule->checkRuleIsComplex()){
            cout << "true";
        } else {
            cout << "false";
        }
        cout << endl;

        cout << "Interval:" << rule->getInterval() << endl;
        cout << "getting weekdays" << endl;
        vector <short> weekdays = rule->getWeekDay();
        for (unsigned int i=0; i < weekdays.size(); i++){
            cout << weekdays.at(i) << endl;
        }
    }


}

void EventView::testRecurrence(){
    CRecurrenceRule *rule = new CRecurrenceRule(0,"FREQ=WEEKLY;BYDAY=TU,TH;INTERVAL=2;UNTIL=20111026T091500");

    //rule->setFrequency(YEARLY_RECURRENCE);
    //rule->setInterval(2);
    if(rule->rruleParser("FREQ=WEEKLY;BYDAY=TU,TH;INTERVAL=2;UNTIL=20111026T091500")){
        cout << "New rule created: " << rule->getRrule().c_str() << endl;
        cout << rule->toString().c_str() << endl;
        cout << "type:" << rule->getRuleType() << endl;
    } else {
        cout << "Failed to create rule" << endl;
    }

}

void EventView::on_pushButton_clicked()
{
    DialogEditRule winEditRule(this);
    //winEditRule.setWindowState(winEditRule.windowState() ^ Qt::WindowMaximized);
    winEditRule.setRule(QString(this->m_firstrule->getRrule().c_str()));
    winEditRule.exec();
    if(winEditRule.result()){
        if(saveRule(winEditRule.getRule(),winEditRule.getUntil(),winEditRule.getRType())){
            cout << "RULE WAS SAVED!" << endl;
            loadEventInfo();
        } else {
            cout << "EDIT FAILURE!" << endl;
        }
    }
}

bool EventView::saveRule(QString rule, int until, int rType){

    cout << "EventView::saveRule(" << rule.toLocal8Bit().constData();
    cout << ", " << until << ", " << rType << ")" << endl;

    if(this->m_firstrule){
        this->m_firstrule->setRrule(rule.toLocal8Bit().constData());
        if(this->m_firstrule->rruleParser(this->m_firstrule->getRrule())){
            cout << "parsing okay" << endl;
            cout << "RULE IS NOW:" << endl;
            cout << m_firstrule->toString();
            this->m_event->getRecurrence()->setRtype(rType);
            this->m_event->setUntil(until);

            int e;
            mcalendar->modifyEvent(this->m_event,this->m_calendarid,e);
            if (e != CALENDAR_OPERATION_SUCCESSFUL){
                cout << "failed to update event with new rule!" << endl;
            } else {
                cout << "success updating event with new rule!" << endl;
            }
        } else {
            cout << "failed to parse rule. not saving" << endl;
        }
    }


    return true;
}

QString EventView::resolveRType(int rType){
    QString result;

    switch (rType) {
    case 0:
        result = "External";
        break;
    case 1:
        result = "Daily";
        break;
    case 2:
        result = "Every Workday";
        break;
    case 3:
        result = "Weekly";
        break;
    case 4:
        result = "Monthly";
        break;
    case 5:
        result = "Yearly";
        break;
    case 6:
        result = "Complex Rule";
        break;
    default:
        result = "UNKNOWN";

    }
    return result;
}
