#include "dialogeditrepeat.h"
#include "ui_dialogeditrepeat.h"
#include <iostream>
#include "dialogruledaily.h"
#include "dialogruleweekly.h"
#include "dialogrulemonthly.h"
#include "dialogruleyearly.h"
#include <QAbstractButton>


using namespace std;

DialogEditRepeat::DialogEditRepeat(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DialogEditRepeat)
{
    ui->setupUi(this);

    this->rType = 0;

    ui->buttonBox->addButton("Never", QDialogButtonBox::ActionRole);

}

DialogEditRepeat::~DialogEditRepeat()
{
    delete ui;
}

void DialogEditRepeat::on_listWidget_activated(QModelIndex index)
{
    cout << "Selected: " << index.data().toString().toLocal8Bit().constData() << endl;
    if(index.data().toString() == "Daily"){

        DialogRuleDaily winDailyRule(this);
        winDailyRule.setWindowState(winDailyRule.windowState() ^ Qt::WindowMaximized);
        winDailyRule.exec();
        if(winDailyRule.result()){
            this->repeatRule = winDailyRule.getRule();
            ui->lineEdit->setText(winDailyRule.getRule());
            this->rType = winDailyRule.getRType();
        }
        return;
    }

    if(index.data().toString() == "Weekly"){
        cout << "WEEKLY!" << endl;

        DialogRuleWeekly winWeeklyRule(this);
        winWeeklyRule.setWindowState(winWeeklyRule.windowState() ^ Qt::WindowMaximized);
        winWeeklyRule.exec();
        if(winWeeklyRule.result()){
            this->repeatRule = winWeeklyRule.getRule();
            ui->lineEdit->setText(winWeeklyRule.getRule());
            this->rType = winWeeklyRule.getRType();
        }
        return;
    }

    if(index.data().toString() == "Monthly"){
        cout << "MONTHLY!" << endl;

        DialogRuleMonthly winMonthlyRule(this);
        winMonthlyRule.setWindowState(winMonthlyRule.windowState() ^ Qt::WindowMaximized);
        winMonthlyRule.exec();
        if(winMonthlyRule.result()){
            this->repeatRule = winMonthlyRule.getRule();
            ui->lineEdit->setText(winMonthlyRule.getRule());
            this->rType = winMonthlyRule.getRType();
        }
        return;
    }

    if(index.data().toString() == "Yearly"){
        cout << "YEARLY!" << endl;

        DialogRuleYearly winYearlyRule(this);
        winYearlyRule.setWindowState(winYearlyRule.windowState() ^ Qt::WindowMaximized);
        winYearlyRule.exec();
        if(winYearlyRule.result()){
            this->repeatRule = winYearlyRule.getRule();
            ui->lineEdit->setText(winYearlyRule.getRule());
            this->rType = winYearlyRule.getRType();
        }
        return;
    }

}

void DialogEditRepeat::daily_rule_accepted(){

}

QString DialogEditRepeat::getRepeat(){
    return this->repeatRule;
}

int DialogEditRepeat::getRtype(){
    return this->rType;
}

void DialogEditRepeat::on_buttonBox_clicked(QAbstractButton* button)
{
    cout << button->text().toLocal8Bit().constData() << endl;
    if(button->text() == "Never"){
        cout << "NEVER!" << endl;

        this->repeatRule = "NEVER";
        ui->lineEdit->setText("NEVER");
        ui->listWidget->clearSelection();
        this->rType = -1;

        return;
    }
}
