import _midgard as midgard, os

# Keep the connection and configuration as global variables
configuration = midgard.config()
configuration.dbtype = 'SQLite'
configuration.database = 'temp_maecalories_preinit'
#configuration.blobdir =  os.path.expanduser('~/.midgard2/blobs/' + configuration.database)
connection = midgard.connection()

connected = connection.open_config(configuration)
if not connected:
    raise Exception('Could not open database connection, reason: %s' % midgard._connection.get_error_string())


used_classes = [
            'midgard_person',
            'org_maemo_garage_maecalories_pointslog',
            'org_maemo_garage_maecalories_weightlog'
]

if not midgard.storage.create_base_storage():
    raise Exception("could not create thread for create_base_storage()")
for classname in used_classes:
    if not midgard.storage.create_class_storage(classname):
        raise Exception("could not create thread for create_class_storage(%s)" % classname)

dbpath = os.path.expanduser('~/.midgard2/data/' + configuration.database + '.db')
targetpath = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'resources', 'preinit.db')

print "os.rename(%s, %s)" % (dbpath, targetpath)
os.rename(dbpath, targetpath)