import gtk, hildon, storage, calculator

class create_window:
    def __init__(self, template=None):
        self.window = hildon.StackableWindow()
        self.window.set_title('New points log entry')

        menu = hildon.AppMenu()
        self.template_button = hildon.CheckButton(gtk.HILDON_SIZE_AUTO)
        self.template_button.set_label('Use as template')
        menu.append(self.template_button)

        self.backdate_button = hildon.DateButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        #import time
        # For some reason I can't fogure out how to set the range
        #self.backdate_button = hildon.HildonDateButton.new_with_year_range(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, int(time.strftime('%Y'))-1, int(time.strftime('%Y')))
        self.backdated =  False
        self.backdate_button.set_label('Backdate')
        self.backdate_button.connect('value-changed', self.backdate_changed)
        menu.append(self.backdate_button)

        menu.show_all()
        self.window.set_app_menu(menu)
        self.main_layout()
        if template != None:
            print "filling values from template #%d (%.1f, %s)" % (template.id, template.points, template.notes)
            self.points_callback(template.points)
            notesbuffer = self.notes.get_buffer()
            notesbuffer.set_text(str(template.notes))

    def backdate_changed(self, *args):
        self.backdated = True

    def main_layout(self):
        # Divide to two halves
        hbox = gtk.HBox(homogeneous=True)
        self.left_column = gtk.VBox()
        hbox.add(self.left_column)
        self.right_column = gtk.VBox()
        hbox.add(self.right_column)
        self.window.add(hbox)
        
        notes_label = gtk.Label('Notes')
        notes_label.set_alignment(xalign=0, yalign=0)
        self.left_column.pack_start(notes_label, False, False)
        self.notes = hildon.TextView()
        self.left_column.pack_start(self.notes, True, True)

        calc_button = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, 'Calculate')
        calculator.instance.render_inputs(self.right_column, calc_button, self.points_callback)
        self.right_column.pack_start(calc_button)

        points_container = gtk.HBox(homogeneous=True)
        points_label = gtk.Label('Points:')
        points_label.set_alignment(xalign=1, yalign=0.5)
        points_container.pack_start(points_label)
        self.points = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        # TODO: How to use (only) numeric with dots (to input floats)
        self.points.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_NUMERIC | gtk.HILDON_GTK_INPUT_MODE_SPECIAL)
        points_container.pack_start(self.points)
        self.right_column.pack_start(points_container)

        self.savebutton = hildon.Button(gtk.HILDON_SIZE_THUMB_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, 'Save')
        self.savebutton.connect('clicked', self.save)
        self.right_column.pack_start(self.savebutton, False, False)

    def points_callback(self, points):
        import math
        if math.floor(points) != points:
            self.points.set_text("%.1f" % points)
        else:
            self.points.set_text("%d" % points)

    def save(self, *args):
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 1)
        while gtk.events_pending():
            gtk.main_iteration()
        import time
        entry = storage.midgard.mgdschema.org_maemo_garage_maecalories_pointslog()
        entry.stock = self.template_button.get_active()
        entry.points = float(self.points.get_text())
        notesbuffer = self.notes.get_buffer()
        entry.notes = notesbuffer.get_text(notesbuffer.get_start_iter(), notesbuffer.get_end_iter()).strip()
        entry.person = storage.instance.person.id

        if self.backdated:
            import datetime
            date_tuple = self.backdate_button.get_date()
            entry.time = datetime.datetime(date_tuple[0], date_tuple[1]+1, date_tuple[2], 12, 0, 0)
        else:
            entry.time = storage.utcstamp()

        try:
            entry.create()
        except:
            hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)
            note = hildon.Note('information', window, "Failed to create log entry, error: %s" . storage.midgard._connection.get_error_string())
            gtk.Dialog.run(note)
        print "Saved points log entry #%d with datetime %s" % (entry.id, repr(entry.time))
        # TODO: Just connect to signal in storage and be done with it
        storage.instance.update_caches()
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)
        while gtk.events_pending():
            gtk.main_iteration()
        self.window.destroy()

    def run(self):
        self.window.show_all()

class list_window:
    def __init__(self):
        self.window = hildon.StackableWindow()
        self.window.set_title('Points log')
        # Have a box just in case
        self.main_box = gtk.HBox()
        self.window.add(self.main_box)
        self.render_empty_pannable(self.main_box)

    def run(self):
        self.window.show_all()
        self.load_data()

    def render_empty_pannable(self, container):
        import gobject
        self.liststore = gtk.ListStore(
            gobject.TYPE_STRING, # date as string ?
            gobject.TYPE_STRING, #points (as string)
            gobject.TYPE_STRING, # notes (first line)
        )

        self.treeview = gtk.TreeView(self.liststore)

        datecolumn = gtk.TreeViewColumn()
        datecolumn.set_title('Datetime')
        self.treeview.append_column(datecolumn)
        pointscolumn = gtk.TreeViewColumn()
        pointscolumn.set_title('Points')
        self.treeview.append_column(pointscolumn)
        notescolumn = gtk.TreeViewColumn()
        notescolumn.set_title('Notes')
        self.treeview.append_column(notescolumn)

        daterenderer = gtk.CellRendererText()
        datecolumn.pack_start(daterenderer)
        datecolumn.add_attribute(daterenderer, 'text', 0)
        pointsrenderer = gtk.CellRendererText()
        pointscolumn.pack_start(pointsrenderer)
        pointscolumn.add_attribute(pointsrenderer, 'text', 1)
        notesrenderer = gtk.CellRendererText()
        notescolumn.pack_start(notesrenderer)
        notescolumn.add_attribute(notesrenderer, 'text', 2)

        pannable_area = hildon.PannableArea()
        pannable_area.add(self.treeview)
        pannable_area.show_all()
        container.pack_start(pannable_area)

    def load_data(self):
        # This might take a while, set indicator
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 1)
        while gtk.events_pending():
            gtk.main_iteration()

        # Put our data to the liststore
        # TODO: How to make "infinite scroll" where we limit initial resultset and load more data as we scroll down ?
        qb = storage.midgard.query_builder('org_maemo_garage_maecalories_pointslog')
        qb.add_order('time', 'DESC');
        # Before the infinite scroll is done limit to somewhat sane amount of items
        qb.set_limit(100)
        items = qb.execute()
        for item in items:
            try:
                first_line = item.notes.splitlines()[0]
            except IndexError:
                first_line = '<empty>'
            self.liststore.append((
                item.time.strftime('%Y-%m-%d %H:%M Z'),
                "%.1f" % item.points,
                first_line
            ))
            # Render as we go
            while gtk.events_pending():
                gtk.main_iteration()
        
        # Done, clear the indicator
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)
        while gtk.events_pending():
            gtk.main_iteration()

class template_selector():
    def __init__(self, limit=None):
        import gobject
        self.liststore = gtk.ListStore(
            gobject.TYPE_STRING, # notes (first line)
            gobject.TYPE_STRING, #points (as string)
            gobject.TYPE_STRING, # guid (this we pass on)
        )
        qb = storage.midgard.query_builder('org_maemo_garage_maecalories_pointslog')
        qb.add_constraint('stock', '=', True)
        qb.add_order('time', 'DESC');
        if limit != None:
            qb.set_limit(limit)
        items = qb.execute()
        for item in items:
            self.liststore.append((
                item.notes.splitlines()[0],
                "%.1f" % item.points,
                item.guid
            ))

        # TODO: How to best show the points value too ?
        # TODO: make searchable
        self.selector = hildon.TouchSelector(text=True)
        self.selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        self.selector.set_model(0, self.liststore)
        #self.selector.append_text_column(self.liststore, False)
        #self.selector.set_model(1, self.liststore)

    def get_selected_guid(self):
        index = self.active_row
        if index == -1:
            raise Exception("No selection")
        row = self.liststore[index]
        guid = self.liststore.get(row.iter, 2)[0]
        print "got guid %s from index %d" % (guid, index)
        return guid

    def run_dialog(self, window, callback):
        self.selector.set_active(0, -1)
        self.dialog = hildon.PickerDialog(window)
        self.dialog.set_title('Select template')
        self.dialog.set_selector(self.selector)
        ret = gtk.Dialog.run(self.dialog)
        self.active_row = self.selector.get_active(0)
        #print "run_dialog got ret %s" % repr(ret)
        #print "active row %d" % self.active_row
        self.dialog.destroy()
        return ret
        

